/**
 * Class Name	: Zip
 * Description	: zip  Ŭ
 * Date 				: 2002/12/28
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/28 first created.
 */

package com.conv2.imageGS.Util.Zip;

import java.io.*;
import java.util.zip.*;
import java.util.*;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ش 丮  ϵ zip  Ѵ. <p>
 * 
 *  ó : http://java.freehosting.co.kr/java/messages/368.html <br>
 *  :  <p>
 * 
 *  zip ϳ   丮  θ̶, root  θ   ִ.<br>
 * ̷  ϱ ,   丮  θ root  θ   ֵ   ߴ.<p>
 *
 * imageGS API Zip Ű   ⿣  ̳, <br>
 * ó õ Ʈũ ȯ濡 ȿ   ǹǷ ߰Ͽ. <p>
 * 
 * [] unix/linux  Windows ȯ Ͽ ణ ٸ. ̸ Zip(zipFile, srcPath)  ϱ ٶ.<br>
 * [] compressZip()  κ ݵ ϼ!<p>
 *   
 * @author , Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class Zip
{	
	private static boolean isRecursive = true;
	private static ZipOutputStream zos = null;
	private static String srcPath = null;
	private static boolean presentPath = true;
	private static String relativePath = null;
	private static Vector delete_files_vector = null;
	private static File zipfile = null;
	
	/**
	 *  : Ʈδ  ϳ root   丮  丮̴.
	 *
	 *  ڿ  ش zipFile ϸ  Ȳ  Ѵ.<p>
	 * 
	 * @param	zipFile	 zip ϸ ( θ  Ѵ!)
	 * @param	srcPath	  丮 ( θ  Ѵ!)
	 * @exception ImageGSException srcPath ̰ų   , zipFile ̹  
	 */
	public Zip(String zipFile, String srcPath) throws ImageGSException
	{
		init(zipFile, srcPath, true);
	}

	/**
	 *  :  ϳ root   丮  丮, srcPath   ̰ ִ. <br>
	 * ظϸ presentPath true ϱ ٶ! <p>
	 *
	 *  ڿ  ش zipFile ϸ  Ȳ  Ѵ.<p>
	 *  
	 * @param	zipFile	 zip ϸ ( θ  Ѵ!)
	 * @param	srcPath	  丮 ( θ  Ѵ!)
	 * @param	presentPath	true ̸  ϳ root   丮  丮, false ̸  ϳ root srcPath  Ѵ.
	 * @exception ImageGSException srcPath ̰ų   , zipFile ̹  
	 */
	public Zip(String zipFile, String srcPath, boolean presentPath) throws ImageGSException 
	{
		init(zipFile, srcPath, presentPath);
	}

	private void init(String zipFile, String srcPath1, boolean presentPath1) throws ImageGSException
	{
		try
		{
			presentPath = presentPath1;

			// srcPath üũ
			File srcPath_fp = new File(srcPath);
			if(srcPath == null || !srcPath_fp.exists())
			{
				throw new ImageGSException(this.getClass().getName() + ">>" 
															+ ErrorMsg.ERRORTHISFILEISNOTEXIST + " (" + srcPath + ")");
			}

			// srcPath  ڿ '/' ٿ ְų '\\' ٿ ִٸ Ѵ. for Windows OS
			if(srcPath.charAt(srcPath.length()-1) == '/' || srcPath.charAt(srcPath.length()-1)=='\\')
			{
				srcPath = srcPath.substring(0, srcPath.length()-1);	
			}

			srcPath = srcPath1;

			// zipFile üũ
			zipfile = new File(zipFile);
			
			// ش zipFile ϸ  Ȳ .
			if(zipfile.exists())
			{
				throw new ImageGSException(this.getClass().getName() + " >> " 
													+ ErrorMsg.ERRORTHISFILEISEXIST + " (" + zipfile.getPath() + ")");	
			}

			zos = new ZipOutputStream( new FileOutputStream(zipFile) );
		}
		catch(IOException e)
		{
			if(zos != null) { try{ zos.close();} catch(IOException se){} }
			if(zipfile != null) { if(zipfile.exists()) { zipfile.delete(); } }
			throw new ImageGSException( e.getMessage() );
		}

	}

	/**
	 *  Ѵ. <p>
	 * 
	 * root srcPath  丮   ,  丮 srcPath ġ ϸ Ǿ!<br>
	 *  츦 Ͽ defensive coding Ѵ. , ġϸ  Ȳ  ̴.<br>
	 * ׷ Ư windows ȯ  ̹ϹǷ     ̸ ϶. <p>
	 * 
	 * []  丮   ִ  : System.out.println( GetSystemProperties.getValue("user.dir") ); <p>
	 * 
	 * @exception ImageGSException  
	 */
	public void compressZip() throws ImageGSException
	{
		File srcPath_fp = null;

		try
		{
			//   н Ʈ...
			if(presentPath == false)
			{
				srcPath_fp = new File(srcPath);
				outputEntry(srcPath_fp);	
				zos.close();
			}
			//  н    丮 Ʈ...
			else if(presentPath == true)
			{
				//  ϰ ִ н ˾Ƴ.
				Properties p = System.getProperties();
				String user_dir = p.getProperty("user.dir");
				
				//  ڵ
				// windows ȯ 
				String os = p.getProperty("os.name").substring(0, 3);
				if(os.equals("Win"))
				{
					StringBuffer sb_tmp = new StringBuffer();
					
					for(int i=0; i<srcPath.length(); i++)
					{
						if(srcPath.charAt(i) == '/') sb_tmp.append("\\");
						else sb_tmp.append(srcPath.charAt(i));	
					}
					
					String tmp = sb_tmp.toString();
					
					//int zip_execute_flag = user_dir.compareToIgnoreCase(tmp.substring(0, user_dir.length()));
					
					int zip_execute_flag;
					
					if(tmp.length() > user_dir.length())
						zip_execute_flag = user_dir.compareToIgnoreCase(tmp.substring(0, user_dir.length()));
					else 
						zip_execute_flag = user_dir.compareToIgnoreCase(tmp);
											
					// ࿡ ġϸ	
					if(zip_execute_flag == 0)
					{ 
						throw new ImageGSException(this.getClass().getName() + " >> " 
															+ "user_dir is equal " + srcPath );
					}
				}
				else 
				{
					//int zip_execute_flag = user_dir.compareToIgnoreCase(srcPath.substring(0, user_dir.length()));
					
					int zip_execute_flag;
					
					if(srcPath.length() > user_dir.length())
						zip_execute_flag = user_dir.compareToIgnoreCase(srcPath.substring(0, user_dir.length()));
					else 
						zip_execute_flag = user_dir.compareToIgnoreCase(srcPath);
					
					// ࿡ ġϸ	
					if(zip_execute_flag == 0) 
					{
						throw new ImageGSException(this.getClass().getName() + " >> " 
													+ "user_dir is equal " + srcPath );
					}					
				}
				
				String rootPath_tmp = null;
				String rootPath = null;
	
				// srcPath ǵ޺κ  .
				//   '/'  File.separatorChar ϶ Ѵ.
				if(srcPath.charAt(srcPath.length()-1)==File.separatorChar)
				{
					rootPath_tmp = srcPath.substring(0, srcPath.length()-1);
					rootPath = rootPath_tmp.substring(rootPath_tmp.lastIndexOf(File.separator)+1);
				}
				else 
				{
					rootPath = srcPath.substring(srcPath.lastIndexOf(File.separator)+1);
				}
			
				// only windows ȯ
				int index = 0;
				int length = 0;
				int check =0;

				if(os.equals("Win"))
				{
					length = rootPath.length();
					for(int i=length-1; i>=0; i--)
					{
						if(i==length-1)
						{
							if(rootPath.charAt(i) == '\\' || rootPath.charAt(i) == '/')
							{
								check = 1;
								continue;
							}
						}
						
						if(rootPath.charAt(i) == '\\' || rootPath.charAt(i) == '/')
						{
							index = i; 
							break;	
						}
					}
					
					if(check == 0) rootPath = rootPath.substring(index+1);
//					else if(check==1) rootPath = rootPath.substring(index+1, length-1); 
				}
				
				relativePath = user_dir + File.separator + rootPath;
				
				// srcPath relativePath  ī.
				File relativePath_fp = new File(relativePath);
	
				// relativePath   丮 Ѵ.
				if(!relativePath_fp.exists())  relativePath_fp.mkdirs(); 
	
				// copy...
				srcPath_fp = new File(srcPath);
				copy_directory(srcPath_fp);

				//  ϱ Ѵ. rootPath θ ƴ  !
				File rootPath_fp = new File(rootPath);
				outputEntry(rootPath_fp);
				zos.close();
	
				// zip  relativePath Ѵ.
				remove_directory(relativePath_fp);
			}
		} 
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage());
		}
	}

	private static void outputEntry(File f) throws Exception
	{
		String adjustedPath = f.getPath().replace(File.separatorChar, '/');
		if( f.isDirectory() && !adjustedPath.endsWith("/"))
		{
			adjustedPath += "/";
		}

		ZipEntry entry = new ZipEntry(adjustedPath);

		// ֱ  ¥ ִ´.
		entry.setTime(f.lastModified());
		zos.putNextEntry(entry);

		// 丮̸
		if(f.isDirectory())
		{
			if(isRecursive)
			{
				String[] files = f.list();
				for(int i=0; i<files.length; i++)
				{
					outputEntry( new File(f, files[i])); //  ȣ!
				}
			}
		}
		// ̸
		else 
		{
			FileInputStream fis = new FileInputStream(f);
			byte buf[] = new byte[1024];

			for(int cnt; (cnt = fis.read(buf)) != -1; )
			{
				zos.write(buf, 0, cnt);
			}

			fis.close();
		}
	}

    private static void copy_directory(File dir) throws Exception
	{
		String name = dir.getPath();

		// 丮
        if (dir.isDirectory()) 
		{
            String[] children = dir.list();
            for (int i=0; i<children.length; i++) 
			{
                copy_directory(new File(dir, children[i])); //  ȣ
            }
        } 
		// 
		else
		{
			String subPath = name.substring(srcPath.length()); 

			String sub_directory = relativePath + subPath.substring(0, subPath.lastIndexOf(File.separator)+1);

			File sub_directory_fp = new File(sub_directory);
			if(!sub_directory_fp.exists()) sub_directory_fp.mkdirs();  

			copy(new File(name), new File(relativePath+subPath));
        }
	}	

	private static void copy(File src, File dest) throws Exception
	{
		FileInputStream fin = new FileInputStream(src);
		FileOutputStream fout = new FileOutputStream(dest);

		synchronized(fin)
		{
			synchronized(fout)
			{
				byte[] buffer = new byte[256];
				int bytesRead;

				while(true)
				{
					bytesRead = fin.read(buffer);
					if(bytesRead == -1) break;
					fout.write(buffer, 0, bytesRead);
				}
			}
		}

		fout.close();
		fin.close();

		fout = null;
		fin = null;
	}

    private static void remove_directory(File dir) throws Exception
	{
		delete_files_vector = new Vector();

		// 丮   
		remove_all_files_directory(dir);

		// 丮  丮 
		File fp = null;

		for(int i=delete_files_vector.size()-1; i>=0; i--)
		{
			fp = new File((String)delete_files_vector.get(i));
			fp.delete();
		}

		dir.delete();
	}

	private static void remove_all_files_directory(File dir) throws Exception
	{
		// 丮
        if (dir.isDirectory()) 
		{
			delete_files_vector.add((String)dir.getPath());

            String[] children = dir.list();
            for (int i=0; i<children.length; i++) 
			{
                remove_all_files_directory(new File(dir, children[i])); //  ȣ
            }
        } 
		// 
		else
		{
			dir.delete();
        }
	}	
}
