/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class City {
    public String idx;
    public String locName;
    public Color color;
    public BasicStroke stroke;
    public double x;
    public double y;
    public double w;
    public double h;
    public boolean visible;

    public City(String index, String localName, double cx, double cy) {
        this.idx = index;
        this.locName = localName;
        this.color = Color.CYAN;
        this.stroke = new BasicStroke(4.0f);
        this.x = cx;
        this.y = cy;
        this.w = 16.0;
        this.h = 16.0;
        this.visible = false;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getIdx() {
        return this.idx;
    }

    public String getLocName() {
        return this.locName;
    }

    public void setStroke(BasicStroke s) {
        this.stroke = s;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setColor(Color p) {
        this.color = p;
    }

    public Color getColor() {
        return this.color;
    }

    public void setCoordinate(double cx, double cy, double width, double height) {
        this.x = cx;
        this.y = cy;
        this.w = width;
        this.h = height;
    }

    public void drawCircle(Graphics2D g) {
        g.setStroke(this.stroke);
        g.setColor(this.color.brighter());
        g.fill(new Ellipse2D.Double(this.x + 1.0, this.y + 1.0, this.w - 2.0, this.h - 2.0));
        g.setColor(this.color.darker());
        g.draw(new Ellipse2D.Double(this.x, this.y, this.w, this.h));
    }
}

