/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.BinaryProc.Binary2GrayIMG;
import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ChannelViewer
extends JFrame {
    private ChannelViewer() {
    }

    public static void run(short[][] channel, boolean binaryFlag) throws ImageGSException {
        ChannelViewer.run(channel, true, null);
    }

    public static void run(short[][] channel, boolean binaryFlag, String title) throws ImageGSException {
        if (binaryFlag) {
            ChannelViewer.run(Binary2GrayIMG.ShortBinary2GrayIMG((short[][])channel), title);
        } else {
            ChannelViewer.run(channel, title);
        }
    }

    public static void run(short[][] grayChannel) throws ImageGSException {
        ChannelViewer.run(grayChannel, null);
    }

    public static void run(short[][] grayChannel, String title) throws ImageGSException {
        String title_str = null;
        title_str = title == null ? "\uba85\uc554\ub3c4 \uc601\uc0c1\uc785\ub2c8\ub2e4." : title;
        try {
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.gray(grayChannel);
            BufferedImage bi = cb.getBufferedImage();
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(title);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel) throws ImageGSException {
        ChannelViewer.run(redChannel, greenChannel, blueChannel, null);
    }

    public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String title) throws ImageGSException {
        String title_str = null;
        title_str = title == null ? "\uceec\ub7ec \uc601\uc0c1\uc785\ub2c8\ub2e4." : title;
        try {
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.color(redChannel, greenChannel, blueChannel);
            BufferedImage bi = cb.getBufferedImage();
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(title);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(double[][] channel, boolean binaryFlag) throws ImageGSException {
        ChannelViewer.run(channel, true, null);
    }

    public static void run(double[][] channel, boolean binaryFlag, String title) throws ImageGSException {
        if (binaryFlag) {
            ChannelViewer.run(Binary2GrayIMG.DoubleBinary2GrayIMG((double[][])channel), title);
        } else {
            ChannelViewer.run(channel, title);
        }
    }

    public static void run(double[][] grayChannel) throws ImageGSException {
        ChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), null);
    }

    public static void run(double[][] grayChannel, String title) throws ImageGSException {
        ChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), title);
    }

    public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel) throws ImageGSException {
        ChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), null);
    }

    public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String title) throws ImageGSException {
        ChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), title);
    }

    public static void run(BufferedImage bi) throws ImageGSException {
        ChannelViewer.run(bi, null);
    }

    public static void run(BufferedImage bi, String title) throws ImageGSException {
        String title_str = null;
        title_str = title == null ? "BufferedImage\ub97c \ubcf4\uc5ec\uc90d\ub2c8\ub2e4." : title;
        try {
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(title);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
        }
    }
}

