/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileOperation {
    public static void copy(String src_fname, String dest_fname) throws ImageGSException {
        File src = new File(src_fname);
        File dest = new File(dest_fname);
        if (src.isDirectory() || dest.isDirectory()) {
            return;
        }
        try {
            FileOperation.copy(src, dest);
        }
        catch (IOException e) {
            throw new ImageGSException("FileOperation.copy() >> " + e.getMessage());
        }
    }

    private static void copy(File src, File dest) throws IOException {
        if (src.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        FileInputStream fin = new FileInputStream(src);
        FileOutputStream fout = new FileOutputStream(dest);
        FileOperation.StreamCopy(fin, fout);
        fin.close();
        fout.close();
    }

    public static void move(String src_fname, String dest_fname, boolean overwrite) throws ImageGSException {
        File src = new File(src_fname);
        File dest = new File(dest_fname);
        try {
            FileOperation.move(src, dest, overwrite);
        }
        catch (IOException e) {
            throw new ImageGSException("FileOperation.move() >> " + e.getMessage());
        }
    }

    private static void move(File src, File dest, boolean overwrite) throws IOException {
        if (src.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (src.isDirectory()) {
            throw new IOException("Can't move directories");
        }
        if (!dest.isFile()) {
            FileOperation.move(src, dest);
        } else if (dest.isFile() && overwrite) {
            FileOperation.move(src, dest);
        } else {
            if (dest.isFile() && !overwrite) {
                throw new IOException(dest + " exists");
            }
            if (dest.isDirectory()) {
                FileOperation.move(src, new File(dest, src.getName()));
            } else if (dest.getPath().endsWith(System.getProperty("file.separator"))) {
                if (!dest.mkdirs()) {
                    throw new IOException("Could not create " + dest);
                }
                FileOperation.move(src, new File(dest, src.getName()));
            } else {
                String dir = dest.getParent();
                String name = dest.getName();
                if (dir != null && !new File(dir).mkdirs()) {
                    throw new IOException("Could not create " + dir);
                }
                FileOperation.move(src, dest);
            }
        }
    }

    private static void move(File src, File dest) throws IOException {
        FileInputStream fin = new FileInputStream(src);
        FileOutputStream fout = new FileOutputStream(dest);
        FileOperation.StreamCopy(fin, fout);
        fout.close();
        fin.close();
        src.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void StreamCopy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

