<?xml version="1.0" encoding="euc-kr"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" encoding="euc-kr"/>
	<xsl:template match="project">
		<html>
			<style>
				<![CDATA[
				BODY
				{
					font-family:verdana,arial,helvetica,;
					font-size:12pt;
					line-height:150%;
					background-color:#FFFFFF;
				}
				TABLE{background-color:#000000;padding:1;width:600}
				TD{padding:3;}
				]]>
			</style>
			<head><title><xsl:value-of select="@name"/></title></head>
			<body>
				<p/>
<!--				<table>
				<tr>
					<td bgcolor="white">Project-name</td>
					<td bgcolor="white"><xsl:value-of select="@name"/></td>
				</tr>
				<tr>
					<td bgcolor="white">Project-desc</td>
					<td bgcolor="white"><xsl:value-of select="project-desc"/><br/></td>
				</tr>
				</table>-->
				<xsl:apply-templates select="package"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="package">
<!--		Package-name : <xsl:value-of select="@name"/><br/>
		Package-desc : <xsl:value-of select="package-desc"/><br/>-->
		<p/>
		<font size="6">Package <xsl:value-of select="@name"/></font><p/>
		<xsl:value-of select="package-desc"/>
		<xsl:apply-templates select="class">
			<xsl:sort select="@name" data-type="text"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="class">
		<p/>
		<font size="5">Class <xsl:value-of select="@name"/></font> in package <xsl:value-of select="../@name"/> <p/>
		<xsl:value-of select="class-desc" disable-output-escaping="yes"/><p/>
		<xsl:if test="boolean(@implements)">
			This Class implements all properties and methods in <xsl:value-of select="@implements"/><p/>
		</xsl:if>
		<xsl:if test="boolean(@base)">
			This Class has all properties and methods in <xsl:value-of select="@base"/><p/>
		</xsl:if>
		<xsl:apply-templates select="properties"/>
		<p/>
		<xsl:apply-templates select="methods"/>
		<p/>
	</xsl:template>
	<xsl:template match="methods">
		<table>
			<tr bgcolor="#CCCCFF" class="TABLE_TITLE">
				<td colspan="2"> Method Summary</td>
			</tr>
		<xsl:for-each select="method"><!-- <xsl:text>&#32;</xsl:text> means a space-->
			<xsl:sort select="@name" data-type="text"/>
			<tr>
				<td bgcolor="white" width="150"><xsl:value-of select="@type"/></td>
				<td bgcolor="white" width="450">
					<xsl:value-of select="@name"/>
					(<xsl:for-each select="parameter">
						<xsl:value-of select="@type"/><xsl:text>&#32;</xsl:text><xsl:value-of select="@name"/>
						<xsl:if test="position() != last()">,
						</xsl:if>
					</xsl:for-each>)<br/>
					<font size="2"><xsl:value-of select="method-desc"/></font>
				</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template match="properties">
		<table>
			<tr bgcolor="#CCCCFF">
				<td colspan="2" class="TABLE_TITLE"> Property Summary</td>
			</tr>
		<xsl:for-each select="property">
			<xsl:sort select="@name" data-type="text"/>
			<tr>
				<td bgcolor="white" width="150"><xsl:value-of select="@type"/></td>
				<td bgcolor="white" width="450">
					<xsl:value-of select="@name"/><br/>
					<font size="2"><xsl:value-of select="property-desc"/></font>
					<xsl:choose>
						<xsl:when test="@access='read-write'">
							<br/><font size="2">getter method: <xsl:value-of select="@type"/><xsl:text>&#32;</xsl:text>get<xsl:value-of select="@name"/>()</font>
							<br/><font size="2">setter method: void<xsl:text>&#32;</xsl:text>get<xsl:value-of select="@name"/>(<xsl:value-of select="@type"/><xsl:text>&#32;</xsl:text>toSet)</font>
						</xsl:when>
						<xsl:when test="@access='read'">
							<br/><font size="2">getter method: <xsl:value-of select="@type"/><xsl:text>&#32;</xsl:text>get<xsl:value-of select="@name"/>()</font>
						</xsl:when>
						<xsl:when test="@access='write'">
							<br/><font size="2">setter method: void<xsl:text>&#32;</xsl:text>get<xsl:value-of select="@name"/>(<xsl:value-of select="@type"/><xsl:text>&#32;</xsl:text>toSet)</font>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template match="collection">
		<p/>
		<font size="5">Collection <xsl:value-of select="@name"/></font> in package <xsl:value-of select="../@name"/>
		<p/>
		Collection <xsl:value-of select="@name"/> can have instance of <xsl:value-of select="@of"/>
		<p/>
		<xsl:if test="count(properties)=0">
			Default Properties by Visua Basic Class Utility.<p/>
		</xsl:if>
		<xsl:if test="count(methods)=0">
			Default Methods by Visual Basic Class Utility.<p/>
		</xsl:if>
		<xsl:apply-templates select="properties"/>
		<p/>
		<xsl:apply-templates select="methods"/>
		<p/>
	</xsl:template>
</xsl:stylesheet>