CK_Item = {};

function Ck_SaveItem(itemLink)
    local itemId = Ck_getItemIdByLink(itemLink);
    local name, link, rarity, level, reqlevel, itype, subtype, _, equipLoc, texture = GetItemInfo(itemLink);
    local itemKey = itemId .. "_" .. name;
    local ff = false;
    for _, sitem in pairs(CK_SavedItem) do
        if (itemKey == sitem) then
            ff = true;
            break;
        end
    end
    if (ff) then 
        return;
    end
    if (CK_Item[itemKey] == nil) then
        --CensusKr_Print("New Item... " .. name);
        CK_Item[itemKey] = {};
        CK_Item[itemKey].itemid = itemId;
        CK_Item[itemKey].name = name;
        CK_Item[itemKey].rarity = rarity;
        CK_Item[itemKey].level = level;
        CK_Item[itemKey].reqlevel = reqlevel;
        CK_Item[itemKey].type = itype;
        CK_Item[itemKey].subtype = subtype;
        CK_Item[itemKey].equipLoc = equipLoc;
        CK_Item[itemKey].texture = texture;
        CK_Item[itemKey].tooltip = Ck_Tooltip(link);
    end;
end

function Ck_getItemIdByLink(itemLink)
    local found, _, itemString = string.find(itemLink, "^|%x+|H(.+)|h%[.+%]");
    local found, _, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = string.find(itemString, "^item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)")
    return itemId;
end

function Ck_Tooltip(itemLink)
    local TooltipNameBase = "CK_Tooltip";
    local tooltipFrame = getglobal(TooltipNameBase);
    tooltipFrame:SetOwner(TargetFrame, "ANCHOR_BOTTOMRIGHT");
    tooltipFrame:SetHyperlink(itemLink);
    local htmlstr = nil;
    for idx = 1, tooltipFrame:NumLines() do
        local textLeft = nil;
        local textRight = nil;
        ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textLeft = "<div>" .. ttext:GetText() .. "</div>";
        end
        ttext = getglobal(TooltipNameBase.."TextRight"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textRight = "<div style='float:right;'>" .. ttext:GetText() .. "</div>";
        end
        if (textLeft or textRight) then
        --[[
            if ( textRight) then
                textRight = "\t"..textRight;
            else
                textRight = "";
            end
            ]]
            if (textRight == nil) then
                textRight = "";
            end

            if ( htmlstr ~= nil ) then
                --htmlstr = htmlstr .. "<br />" .. textLeft .. textRight;
                --htmlstr = htmlstr .. textLeft .. textRight;
                htmlstr = htmlstr .. textRight .. textLeft;
            else
                --htmlstr = textLeft .. textRight;
                htmlstr = textRight .. textLeft;
            end
        end
    end
    htmlstr = string.gsub(htmlstr, "\n", "<br />");
    tooltipFrame:ClearLines();
    tooltipFrame:Hide();
    return htmlstr;	
end