-- SavedVars: CK_Auction, CK_Item
CK_Auction = {};
_ck_auc_deposit_rate = 5;

function Ck_ProcessAuction()
    -- ߸  .
    local dprate = GetAuctionHouseDepositRate();
    if (dprate ~= _ck_auc_deposit_rate) then
        return;
    end

    -- list count
    local batch, count = GetNumAuctionItems("list");
    if (count == 0) then 
        return;
    end 

    -- loop scan
    local bidList = {}
    for i=1, count, 1 do
        local itemLink = GetAuctionItemLink("list", i);
        local name, texture, count, _, _, level, bid, _, buyout, _, _, _ = GetAuctionItemInfo("list", i);
        if (itemLink) then
            local itemId = Ck_getItemIdByLink(itemLink);
            Ck_SaveItem(itemLink);
            local itemKey = itemId .. "_" .. name;
            if (count > 1) then
                bid = math.floor(bid / count);
                buyout = math.floor(buyout / count);
            end
            if (bidList[itemKey] == nil) then
                bidList[itemKey] = {};
                bidList[itemKey].minBid = bid;
                bidList[itemKey].avgBid = bid;
                bidList[itemKey].maxBid = bid;
                bidList[itemKey].bide = 1;
                bidList[itemKey].minBuy = buyout;
                bidList[itemKey].avgBuy = buyout;
                bidList[itemKey].maxBuy = buyout;
                if (buyout ~= 0) then
                    bidList[itemKey].buyoute = 1;
                else
                    bidList[itemKey].buyoute = 0;
                end
            else
                if (bidList[itemKey].minBid > bid) then
                    bidList[itemKey].minBid = bid;
                end
                if (bidList[itemKey].maxBid < bid) then
                    bidList[itemKey].maxBid = bid;
                end
                bidList[itemKey].avgBid = math.floor(((bidList[itemKey].avgBid * bidList[itemKey].bide) + bid) / (bidList[itemKey].bide + 1));
                bidList[itemKey].bide = bidList[itemKey].bide + 1;
                if (buyout ~= 0) then
                    if (bidList[itemKey].minBuy > buyout) then
                        bidList[itemKey].minBuy = buyout;
                    end
                    if (bidList[itemKey].maxBuy < buyout) then
                        bidList[itemKey].maxBuy = buyout;
                    end
                    bidList[itemKey].avgBuy = math.floor(((bidList[itemKey].avgBuy * bidList[itemKey].buyoute) + buyout) / (bidList[itemKey].buyoute + 1));
                    bidList[itemKey].buyoute = bidList[itemKey].buyoute + 1;
                end
            end
        end -- end if (itemLink)
    end -- end for
    Ck_SaveAuction(bidList);
end

function Ck_SaveAuction(bid)
    -- realm, faction, timestamp
    local realm = GetRealmName();
    local char = UnitName("player");
    local faction = UnitFactionGroup("player");
    local localDate = CensusPlus_DetermineServerDate();

    if (CK_Auction[realm] == nil) then
        CK_Auction[realm] = {};
    end
    if (CK_Auction[realm][char] == nil) then
        CK_Auction[realm][char] = {};
    end
    if (CK_Auction[realm][char][faction] == nil) then
        CK_Auction[realm][char][faction] = {};
    end
    for itemKey, bidTbl in pairs(bid) do
        if (CK_Auction[realm][char][faction][itemKey] == nil) then
            CK_Auction[realm][char][faction][itemKey] = {};
            --CensusKr_Print("saving New Item: " .. itemId);
        end
        if (CK_Auction[realm][char][faction][itemKey][localDate] == nil) then
            CK_Auction[realm][char][faction][itemKey][localDate] = {};
            CK_Auction[realm][char][faction][itemKey][localDate] = bidTbl.minBid 
                                                            .. "|" .. bidTbl.avgBid 
                                                            .. "|" .. bidTbl.maxBid
                                                            .. "|" .. bidTbl.bide
                                                            .. "|" .. bidTbl.minBuy
                                                            .. "|" .. bidTbl.avgBuy
                                                            .. "|" .. bidTbl.maxBuy
                                                            .. "|" .. bidTbl.buyoute;
        end
    end
end
