import cgi
import os
import sys
import urllib
import md5
import time
import Cookie
import ConfigParser

import grep
import clickyLib 
import exceptionLib
from templateProcessor import templateProcessor, getTemplate 
import session
import config


globalNS = globals()
globalNS['quote'] = urllib.quote
globalNS['escape'] = cgi.escape
globalNS['config'] = config

def run():
    session.removeExpiredSessionsByRandom()    
    cookie = Cookie.SmartCookie()
    user = clickyLib.User()
    try:
        cookie.load(os.environ['HTTP_COOKIE'])
        sess = session.Session(cookie['sid'].value)
    except:
        sess = session.Session()
        sess['uid'] = 'anonymous'
    user.uid = sess['uid']
    user.sess = sess

    form = cgi.FieldStorage()
    if user.uid == 'root':
        action = 'do_' + form.getvalue('action', 'showMain')
    else:
        action = 'do_login'
    try:
        #actionFunc = globals()[action]
        actionFunc = globalNS[action]
        ret = actionFunc(user, form)

    except exceptionLib.Download, msg:
        filePath = msg[0]
        sendDownloadFile(filePath)
        return 
    except Exception, msg:
        print 'Content-Type: text/html\r\n\r\n',
        print 'ERROR : %s' % msg[0]
        try: print 'ERROR : %s' % msg[1]
        except: pass 
        return
    print 'Content-Type: text/html\r\n\r\n',
    print ret,
    return

def sessionInit(sess): # FIXME
    pass

def redirect(redirectUrl):
    teul = getTemplate('skin/redirect.teul')
    return templateProcessor(teul, globalNS, locals())

def errorTeul(message):
    teul = getTemplate('skin/error.teul')
    return templateProcessor(teul, globalNS, locals())

def do_login(user, form): # FIXME absolutely!
    curPath = form.getvalue('curPath', './')
    uid = form.getvalue('uid', '').strip()
    passwd = form.getvalue('passwd', '').strip()

    if uid and passwd:
        m = md5.new(passwd)
        m2 = md5.new(config.passwd)
        if uid == config.uid and m.digest() == m2.digest():
            sess = session.Session() 
            sess['uid'] = uid
            sess['loginTime'] = time.time()
            sid = sess.sid
            user.uid = uid
            user.sess = sess
            cookie = Cookie.SmartCookie()
            cookie['sid'] = sid
            print cookie
            return do_showMain(user, form)
    teul = getTemplate('skin/loginForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_loginForm(user, form):
    curPath = form.getvalue('curPath', './')
    curDirectory = clickyLib.Directory(curPath)
    teul = getTemplate('skin/loginForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_showMain(user, form):
    return do_showList(user, form)

def do_showList(user, form):
    curPath = form.getvalue('curPath', './')
    gotoPath = form.getvalue('gotoPath', curPath)
    sortBy = form.getvalue('sortBy', 'mDate')
    order= form.getvalue('order', 'asc')
    bookmarkName = form.getvalue('bookmarkName', '')
    bookmarks = clickyLib.getBookmarks()
    if 'fileList' not in user.sess.data: # FIXME
        user.sess['fileList'] = []
    if gotoPath != curPath:
        curPath = gotoPath
    elif bookmarkName != '':
        curPath = bookmarks[bookmarkName]
    curDirectory = clickyLib.Directory(curPath)
    curDirectory.sortBy(sortBy, order)
    teul = getTemplate('skin/main.teul')
    return templateProcessor(teul, globalNS, locals())

def do_archiveForm(user, form): # FIXME lazy.......
    curPath = form.getvalue('curPath', '')
    fileList = form.getlist('selectedFObjPath') 
    curPath = curPath[-1] == '/' and curPath[:-1] or curPath
    fname =  len(fileList) == 1 and fileList[0] or curPath
    fname = os.path.split(os.path.splitext(fname)[0])[-1] + '.zip'
    childrenList = []
    for f in fileList:
        if os.path.isdir(f):
            g = os.walk(f)
            for infos in g:
                #path, dirs, flist = g.next()
                path, dirs, flist = infos
                for c in flist:
                    childrenList.append(os.path.realpath(os.path.join(path, c)))
    fileList.extend(childrenList)
    user.sess['fileList'] = fileList
    user.sess['mode'] = 'archive'
    teul = getTemplate('skin/archiveForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_archive(user, form):
    curPath = form.getvalue('curPath', '')
    fname = form.getvalue('fname', '')
    if not (curPath and fname):
        return 'Error'
    fileList = user.sess['fileList']
    arcNames = map(lambda a:a.replace('\\', '/')[len(curPath):], fileList)
    arcNames = map(lambda a:a.startswith('/') and a[1:] or a, arcNames)
    if user.sess['mode'] == 'archive':
        clickyLib.zipFile(os.path.join(curPath, fname), fileList, arcNames)
    else:
        return 'Error'
    user.sess['mode'] = ''
    user.sess['fileList'] = []
    return do_showMain(user, form)


        
def do_copyFObj(user, form):
    user.sess['fileList'] = form.getlist('selectedFObjPath') 
    user.sess['mode'] = 'copy'
    return do_showMain(user, form)

def do_moveFObj(user, form):
    user.sess['fileList'] = form.getlist('selectedFObjPath') 
    user.sess['mode'] = 'move'
    return do_showMain(user, form)

def do_paste(user, form):
    curPath = form.getvalue('curPath', './')
    if not curPath:
        return 'Error'
    errList = []
    for path in user.sess['fileList']:
        try:
            fObj = clickyLib.getFileOrFolderInstanceByPath(path) 
            if user.sess['mode'] == 'copy':
                fObj.copyTo(curPath)
            elif user.sess['mode'] == 'move':
                fObj.moveTo(curPath)
        except:
            errList.append(path)
    user.sess['mode'] = ''
    user.sess['fileList'] = []
    if errList:
        return '<br/>'.join(errList)
    return do_showMain(user, form)

def do_removeFObj(user, form):
    curPath = form.getvalue('curPath', './')
    errList = []
    for path in form.getlist('selectedFObjPath'):
        try:
            fObj = clickyLib.getFileOrFolderInstanceByPath(path) 
            fObj.remove()
        except:
            errList.append(path)
    if errList:
        return '<br/>'.join(errList)
    return do_showMain(user, form)

def do_renameForm(user, form):
    curPath = form.getvalue('curPath', './')
    fObjPath = form.getvalue('fObjPath', '')
    title = 'Rename'
    if not fObjPath:
        return errorTeul('fObjPath is None.')
    fObj = clickyLib.getFileOrFolderInstanceByPath(fObjPath) 
    teul = getTemplate('skin/renameForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_renameFObj(user, form):
    curPath = form.getvalue('curPath', './')
    fObjPath = form.getvalue('fObjPath', '')
    newName = form.getvalue('newName', '')
    fObj = clickyLib.getFileOrFolderInstanceByPath(fObjPath)
    ret = fObj.rename(newName)
    if not ret:
        return errorTeul('%s -> %s : <b>Failed</b>' % (fObj.name, newName))
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % urllib.quote(curPath)
    return redirect(redirectUrl)

def do_view(user, form):
    fObjPath = form.getvalue('fObjPath', '')
    curPath = form.getvalue('curPath', './')
    fObj = clickyLib.File(fObjPath) 
    teul = getTemplate('skin/view.teul')
    #contents = clickyLib.convertPlainIntoHTML(fObj.read())
    contents = fObj.read()
    return templateProcessor(teul, globalNS, locals())

def do_editForm(user, form):
    curPath = form.getvalue('curPath', './')
    fObjPath = form.getvalue('fObjPath', '')
    title = ' '
    if not fObjPath:
        return errorTeul('fObjPath is None.')
    fObj = clickyLib.File(fObjPath) 
    teul = getTemplate('skin/editForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_edit(user, form):
    fObjPath = form.getvalue('fObjPath', '')
    curPath = form.getvalue('curPath', './')
    contents = form.getvalue('contents', '')
    fObj = clickyLib.File(fObjPath) 
    fObj.write(contents)
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % urllib.quote(curPath)
    return redirect(redirectUrl)

def do_changePermissionForm(user, form):
    fObjPath = form.getvalue('fObjPath', '')
    curPath = form.getvalue('curPath', './')
    title = " "
    if not fObjPath:
        return errorTeul('fObjPath is None.')
    fObj = clickyLib.getFileOrFolderInstanceByPath(fObjPath) 
    teul = getTemplate('skin/changePermissionForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_changePermission(user, form):
    curPath = form.getvalue('curPath', './')
    fObjPath = form.getvalue('fObjPath', '')
    ownerRead = form.getvalue('ownerRead', '0')
    ownerWrite = form.getvalue('ownerWrite', '0')
    ownerExecute = form.getvalue('ownerExecute', '0')
    groupRead = form.getvalue('groupRead', '0')
    groupWrite = form.getvalue('groupWrite', '0')
    groupExecute = form.getvalue('groupExecute', '0')
    otherRead = form.getvalue('otherRead', '0')
    otherWrite = form.getvalue('otherWrite', '0')
    otherExecute = form.getvalue('otherExecute', '0')
    fObj = clickyLib.getFileOrFolderInstanceByPath(fObjPath) 
    
    fObj.chmodByBin(ownerRead+ownerWrite+ownerExecute+groupRead+groupWrite+groupExecute+otherRead+otherWrite+otherExecute)
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % urllib.quote(curPath)
    return redirect(redirectUrl)

def do_uploadForm(user, form):
    curPath = form.getvalue('curPath', './')
    title = ' ø'
    teul = getTemplate('skin/uploadForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_upload(user, form): # FIXME
    curPath = form.getvalue('curPath', './')
    fileList = form['file']
    urlList = form.getlist('url')
    newNameList = form.getlist('newName')
    for index in range(len(fileList)):
        try:
            fileName = fileList[index].filename
            fileValue = fileList[index].value
        except:
            fileName = ''
            fileValue = ''
        if fileName:
            fileName = fileName.replace('\\', '/')
            fileName = os.path.split(fileName)[1]
        elif urlList[index]:
            if urlList[index].lower().startswith('http://') and urlList[index].count('/') > 2:
                fileName = os.path.split(urlList[index])[-1] 
            else:
                raise exceptionLib.UploadError
            fileValue = urllib.urlopen(urlList[index]).read() # FIXME try and except.
        if fileName and newNameList[index]:
            fileName = newNameList[index] 
        if fileName:
            clickyLib.fileUpload(curPath, fileName, fileValue)
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % quote(curPath)
    return redirect(redirectUrl)

def do_download(user, form): # FIXME
    filePath = form.getvalue('filePath', '')
    # FIXME permission check
    if not os.path.exists(filePath):
        return errorTemplate('File not exists') 
    banedExtList = ['php'] # FIXME 
    for ext in banedExtList:
        if '.' + ext in filePath: 
            return errorTemplate('Invalid Extention')
    #if os.path.splitext(filePath.lower())[1] in ('.cgi',
        #'.py', '.htm', '.html', '.phtml', '.php', '.php3', '.php4'): # FIXME config Ͽ   ֵ.
    raise exceptionLib.Download, filePath

def sendDownloadFile(filePath):
    import mimetypes
    import shutil
    fPath, fileName = os.path.split(filePath)
    fileType, enc = mimetypes.guess_type(filePath)
    if not fileType:
        fileType = "application/octet-stream"
    http_header = ''' Content-Type: %s
Content-Length: %d
Content-Disposition: attachment; filename="%s"
Pragma: no-cache
Expries: 0\r\n\r\n''' % (fileType, os.path.getsize(filePath), fileName)
    sys.stdout.write(http_header)
    
    shutil.copyfileobj(open(filePath, 'rb'), sys.stdout, 8192)

def do_unzip(user, form):
    curPath = form.getvalue('curPath', './')
    filePath = form.getvalue('filePath' , '')
    if not filePath:
        return errorTeul('filePath is None.')
    targetPath = os.path.split(filePath)[0]
    clickyLib.unzipFile(filePath, targetPath)
    return do_showMain(user, form)

def do_createFolderForm(user, form):
    curPath = form.getvalue('curPath', './')
    title = '  '
    teul = getTemplate('skin/createFolderForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_createFolder(user, form):
    curPath = form.getvalue('curPath', './')
    folderName = form.getvalue('folderName', '')
    ret = clickyLib.createFolder(curPath, folderName)
    if not ret:
        return errorTeul('Failed.')
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % urllib.quote(curPath)
    return redirect(redirectUrl)

def do_createFileForm(user, form):
    curPath = form.getvalue('curPath', './')
    title = '  '
    teul = getTemplate('skin/createFileForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_createFile(user, form):
    curPath = form.getvalue('curPath', './')
    fileName = form.getvalue('fileName', '')
    contents = form.getvalue('contents', '')
    ret = clickyLib.createFile(curPath, fileName, contents) 
    if not ret:
        return errorTeul('Failed.')
    redirectUrl = 'clicky.py?action=showMain&curPath=%s' % urllib.quote(curPath)
    return redirect(redirectUrl)

def do_admin(user, form):
    curPath = form.getvalue('curPath', './')
    teul = getTemplate('skin/admin.teul')
    return templateProcessor(teul, globalNS, locals())

def do_bookmarkManageForm(user, form):
    bookmarks = clickyLib.getBookmarks()
    curPath = form.getvalue('curPath', './')
    teul = getTemplate('skin/bookmarkManageForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_addBookmark(user, form):
    curPath = form.getvalue('curPath', './')
    bookmarkName = form.getvalue('bookmarkName', '')
    bookmarkPath = form.getvalue('bookmarkPath', './')
    clickyLib.addBookmark(bookmarkName, bookmarkPath)
    return do_bookmarkManageForm(user, form)

def do_removeBookmark(user, form):
    curPath = form.getvalue('curPath', './')
    bookmarkName = form.getvalue('bookmarkName', '')
    clickyLib.removeBookmark(bookmarkName)
    return do_bookmarkManageForm(user, form)

def do_configForm(user, form):
    conf = ConfigParser.ConfigParser()
    conf.read('setup.py')
    for section in conf.sections():
        for option in conf.options(section):
            locals()[option] = conf.get(section, option)
    teul = getTemplate('skin/configForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_config(user, form):
    homeUrl = form.getvalue('homeUrl', 'http://')
    homePath = form.getvalue('homePath', './')
    rootPath = form.getvalue('rootPath', './')
    passwd = form.getvalue('passwd', './')
    charset = form.getvalue('charset', 'euc-kr')
    lang = form.getvalue('lang', 'kr')
    conf = ConfigParser.ConfigParser()
    conf.add_section('env')
    conf.set('env', 'rootpath', rootPath)
    conf.set('env', 'homepath', homePath) # FIXME
    conf.set('env', 'homeurl', homeUrl)
    conf.set('env', 'charset', charset)
    conf.set('env', 'lang', lang)
    conf.set('env', 'passwd', passwd)
    conf.set('env', 'lang', lang)
    conf.write(file('setup.py', 'w'))
    return do_configForm(user, form)

# FIXME will be added fonctions
#def do_regExtInfoForm(user, form):
#    curPath = form.getvalue('curPath', './')
#    teul = getTemplate('skin/regExtInfoForm.teul')
#    return templateProcessor(teul, globalNS, locals())

#def do_regExtInfo(user, form):
#    curPath = form.getvalue('curPath', './')
#    ext = form.getvalue('ext', '')
#    icon = form.getvalue('icon', '')
#    clickyLib.loadInfoOfExts()
   
   
def do_searchForm(user, form):
    curPath = form.getvalue('curPath', './')
    action = form.getvalue('action', 'grep')
    recusive = form.getvalue('recusive', False)
    keyword = form.getvalue('keyword', '')
    sortBy = form.getvalue('sortBy', '')
    order= form.getvalue('order', '')
    filePattern = form.getvalue('filePattern', '')
    teul = getTemplate('skin/search.teul')
    if 'fileList' not in user.sess.data: # FIXME
        user.sess['fileList'] = []
    return templateProcessor(teul, globalNS, locals())
     
  
def do_search(user, form): # FIXME
    curPath = form.getvalue('curPath', './')
    keyword = form.getvalue('keyword', None)
    recusive = form.getvalue('recusive', False)
    action = form.getvalue('action', 'grep')
    sortBy = form.getvalue('sortBy', 'mDate')
    order= form.getvalue('order', 'asc')
    filePattern = form.getvalue('filePattern', '')
    fObjList = clickyLib.Search(curPath, keyword, recusive)
    fObjList.sortBy(sortBy, order)
    if 'fileList' not in user.sess.data: # FIXME
        user.sess['fileList'] = []
    teul = getTemplate('skin/search.teul')
    return templateProcessor(teul, globalNS, locals())

def do_grepForm(user, form):
    curPath = form.getvalue('curPath', './')
    action = form.getvalue('action', 'grep')
    recusive = form.getvalue('recusive', False)
    keyword = form.getvalue('keyword', '')
    sortBy = form.getvalue('sortBy', '')
    order= form.getvalue('order', '')
    if 'fileList' not in user.sess.data: # FIXME
        user.sess['fileList'] = []
    teul = getTemplate('skin/search.teul')
    return templateProcessor(teul, globalNS, locals())
    
def do_grep(user, form): # FIXME
    curPath = form.getvalue('curPath', './')
    keyword = form.getvalue('keyword', None)
    action = form.getvalue('action', 'grep')
    sortBy = form.getvalue('sortBy', 'mDate')
    order= form.getvalue('order', 'asc')
    recusive = form.getvalue('recusive', False)
    filePattern = form.getvalue('filePattern', None)
    retList = grep.grep(keyword, os.path.join(curPath, filePattern)) 
    fObjList = []
    for fname in retList:
        fObjList.append(clickyLib.File(os.path.join(curPath, fname)))
    fObjList.sort(lambda a, b: cmp(getattr(a, sortBy), getattr(b, sortBy)))
    if order == "desc":
        fObjList.reverse()
    msg = ''
    if len(retList) == 0:
        msg = 'no result'
    if 'fileList' not in user.sess.data: # FIXME
        user.sess['fileList'] = []
    teul = getTemplate('skin/search.teul')
    return templateProcessor(teul, globalNS, locals())
 
def do_shellForm(user, form):
    curPath = form.getvalue('curPath', './')
    result = '' # FIXME
    teul = getTemplate('skin/shellForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_shell(user, form):
    path = form.getvalue('path', './')
    curPath = form.getvalue('curPath', './')
    cmd = form.getvalue('cmd', '')
    clickyLib.cmdChecker(cmd)
    child_stdin, child_stdout = os.popen2(cmd)
    child_stdin.close()
    result = child_stdout.read()
    child_stdout.close()
    teul = getTemplate('skin/shellForm.teul')
    return templateProcessor(teul, globalNS, locals())

def do_showSession(user, form): # FIXME for test
    s = '<b>Vars</b><br/>'
    for key in dir(user.sess):
        if not key.startswith('__'):
            s = s + '%s = %s<br/>' % (key, user.sess[key])
    s = s+'<br/><b>Datas</b><br/>'
    for key in user.sess.data:
        s = s + '%s = %s<br/>' % (key, user.sess[key])
    return s
    
