/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.content.instance;

import java.awt.Color;
import net.hero.engine.base.BackGround;
import net.hero.engine.base.Border;
import net.hero.engine.base.Font;
import net.hero.engine.base.Image;
import net.hero.engine.base.Padding;
import net.hero.engine.content.instance.InstanceImpl;
import net.hero.engine.content.instance.InstanceVisitor;
import net.hero.engine.style.Style;
import net.hero.engine.style.StyleManager;

public class InstanceLabel
extends InstanceImpl
implements BackGround,
Border,
Font,
Image,
Padding {
    protected BackGround background = null;
    protected Border border = null;
    protected Font font = null;
    protected Image image = null;
    protected Padding padding = null;
    protected String text = new String();

    protected InstanceLabel() {
    }

    public static InstanceLabel createInstance(StyleManager styleManager, Style[] changedStyle) {
        InstanceLabel instance = new InstanceLabel();
        instance.background = styleManager.getDefaultStyleBackGround();
        instance.border = styleManager.getDefaultStyleBorder();
        instance.font = styleManager.getDefaultStyleFont();
        instance.image = styleManager.getDefaultStyleImage();
        instance.padding = styleManager.getDefaultStylePadding();
        Style[] styleArray = changedStyle;
        int n = changedStyle.length;
        int n2 = 0;
        while (n2 < n) {
            Style style = styleArray[n2];
            instance.changeStyle(styleManager.createStyle(style));
            ++n2;
        }
        return instance;
    }

    public Style changeStyle(Style style) {
        if (style != null) {
            String family = style.getFamilyName();
            if (family.equals("border")) {
                this.border = (Border)((Object)style);
            } else if (family.equals("background")) {
                this.background = (BackGround)((Object)style);
            } else if (family.equals("font")) {
                this.font = (Font)((Object)style);
            } else if (family.equals("image")) {
                this.image = (Image)((Object)style);
            } else if (family.equals("padding")) {
                this.padding = (Padding)((Object)style);
            }
        }
        return style;
    }

    public String styleToString() {
        Style[] arrayStyle;
        String toString = "";
        Style[] styleArray = arrayStyle = new Style[]{(Style)((Object)this.background), (Style)((Object)this.border), (Style)((Object)this.font), (Style)((Object)this.image), (Style)((Object)this.padding)};
        int n = arrayStyle.length;
        int n2 = 0;
        while (n2 < n) {
            Style style = styleArray[n2];
            if (style != null) {
                toString = String.valueOf(toString) + style.getFamilyName() + "-style=";
                toString = String.valueOf(toString) + "\"";
                toString = String.valueOf(toString) + style.getName();
                toString = String.valueOf(toString) + "\" ";
            }
            ++n2;
        }
        return toString;
    }

    @Override
    public void acceptVisitor(InstanceVisitor visitor) {
        visitor.visitEnter(this);
        visitor.visitLeave(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Color getBackGroundColor() {
        return this.background.getBackGroundColor();
    }

    @Override
    public int getBackGroundStyle() {
        return this.background.getBackGroundStyle();
    }

    @Override
    public Color getBackGroundFillColor() {
        return this.background.getBackGroundFillColor();
    }

    @Override
    public int getBackGroundFillStyle() {
        return this.background.getBackGroundFillStyle();
    }

    @Override
    public void setBackGroundColor(Color backgoundColor) {
        this.background.setBackGroundColor(backgoundColor);
    }

    @Override
    public void setBackGroundStyle(int backgroundStyle) {
        this.background.setBackGroundStyle(backgroundStyle);
    }

    @Override
    public void setBackGroundFillColor(Color backgroundFillColor) {
        this.background.setBackGroundFillColor(backgroundFillColor);
    }

    @Override
    public void setBackGroundFillStyle(int backgroundFillStyle) {
        this.background.setBackGroundFillStyle(backgroundFillStyle);
    }

    @Override
    public Color getBorderRightColor() {
        return this.border.getBorderRightColor();
    }

    @Override
    public int getBorderRightStyle() {
        return this.border.getBorderRightStyle();
    }

    @Override
    public int getBorderRightWidth() {
        return this.border.getBorderRightWidth();
    }

    @Override
    public Color getBorderLeftColor() {
        return this.border.getBorderLeftColor();
    }

    @Override
    public int getBorderLeftStyle() {
        return this.border.getBorderLeftStyle();
    }

    @Override
    public int getBorderLeftWidth() {
        return this.border.getBorderLeftWidth();
    }

    @Override
    public Color getBorderTopColor() {
        return this.border.getBorderTopColor();
    }

    @Override
    public int getBorderTopStyle() {
        return this.border.getBorderTopStyle();
    }

    @Override
    public int getBorderTopWidth() {
        return this.border.getBorderTopWidth();
    }

    @Override
    public Color getBorderBottomColor() {
        return this.border.getBorderBottomColor();
    }

    @Override
    public int getBorderBottomStyle() {
        return this.border.getBorderBottomStyle();
    }

    @Override
    public int getBorderBottomWidth() {
        return this.border.getBorderBottomWidth();
    }

    @Override
    public void setBorderRightColor(Color borderRightColor) {
        this.border.setBorderRightColor(borderRightColor);
    }

    @Override
    public void setBorderRightStyle(int borderRightStyle) {
        this.border.setBorderRightStyle(borderRightStyle);
    }

    @Override
    public void setBorderRightWidth(int borderRightWidth) {
        this.border.setBorderRightWidth(borderRightWidth);
    }

    @Override
    public void setBorderLeftColor(Color borderLeftColor) {
        this.border.setBorderLeftColor(borderLeftColor);
    }

    @Override
    public void setBorderLeftStyle(int borderLeftStyle) {
        this.border.setBorderLeftStyle(borderLeftStyle);
    }

    @Override
    public void setBorderLeftWidth(int borderLeftWidth) {
        this.border.setBorderLeftWidth(borderLeftWidth);
    }

    @Override
    public void setBorderTopColor(Color borderTopColor) {
        this.border.setBorderTopColor(borderTopColor);
    }

    @Override
    public void setBorderTopStyle(int borderTopStyle) {
        this.border.setBorderTopStyle(borderTopStyle);
    }

    @Override
    public void setBorderTopWidth(int borderTopWidth) {
        this.border.setBorderTopWidth(borderTopWidth);
    }

    @Override
    public void setBorderBottomColor(Color borderBottomColor) {
        this.border.setBorderBottomColor(borderBottomColor);
    }

    @Override
    public void setBorderBottomStyle(int borderBottomStyle) {
        this.border.setBorderBottomStyle(borderBottomStyle);
    }

    @Override
    public void setBorderBottomWidth(int borderBottomWidth) {
        this.border.setBorderBottomWidth(borderBottomWidth);
    }

    @Override
    public String getFontName() {
        return this.font.getFontName();
    }

    @Override
    public Color getFontColor() {
        return this.font.getFontColor();
    }

    @Override
    public int getFontSize() {
        return this.font.getFontSize();
    }

    @Override
    public boolean getFontStrike() {
        return this.font.getFontStrike();
    }

    @Override
    public boolean getFontUnderline() {
        return this.font.getFontUnderline();
    }

    @Override
    public boolean getFontItalic() {
        return this.font.getFontItalic();
    }

    @Override
    public boolean getFontBold() {
        return this.font.getFontBold();
    }

    @Override
    public boolean getFontWordwrap() {
        return this.font.getFontWordwrap();
    }

    @Override
    public int getFontHorizontalAlign() {
        return this.font.getFontHorizontalAlign();
    }

    @Override
    public int getFontVerticalAlign() {
        return this.font.getFontVerticalAlign();
    }

    @Override
    public void setFontName(String fontName) {
        this.font.setFontName(fontName);
    }

    @Override
    public void setFontColor(Color color) {
        this.font.setFontColor(color);
    }

    @Override
    public void setFontSize(int fontSize) {
        this.font.setFontSize(fontSize);
    }

    @Override
    public void setFontStrike(boolean fontStrike) {
        this.font.setFontStrike(fontStrike);
    }

    @Override
    public void setFontUnderline(boolean fontUnderline) {
        this.font.setFontUnderline(fontUnderline);
    }

    @Override
    public void setFontItalic(boolean fontItalic) {
        this.font.setFontItalic(fontItalic);
    }

    @Override
    public void setFontBold(boolean fontBold) {
        this.font.setFontBold(fontBold);
    }

    @Override
    public void setFontWordwrap(boolean fontWordwrap) {
        this.font.setFontWordwrap(fontWordwrap);
    }

    @Override
    public void setFontHorizontalAlign(int fontHorizontalAlign) {
        this.font.setFontHorizontalAlign(fontHorizontalAlign);
    }

    @Override
    public void setFontVerticalAlign(int fontVerticalAlign) {
        this.font.setFontVerticalAlign(fontVerticalAlign);
    }

    @Override
    public int getImageSource() {
        return this.image.getImageSource();
    }

    @Override
    public String getImagePath() {
        return this.image.getImagePath();
    }

    @Override
    public String getImageData() {
        return this.image.getImageData();
    }

    @Override
    public int getImageFill() {
        return this.image.getImageFill();
    }

    @Override
    public int getImageAlignVertical() {
        return this.image.getImageAlignVertical();
    }

    @Override
    public int getImageAlignHorizontal() {
        return this.image.getImageAlignHorizontal();
    }

    @Override
    public void setImageSource(int imageSource) {
        this.image.setImageSource(imageSource);
    }

    @Override
    public void setImagePath(String imagePath) {
        this.image.setImagePath(imagePath);
    }

    @Override
    public void setImageData(String imageData) {
        this.image.setImageData(imageData);
    }

    @Override
    public void setImageFill(int imageFill) {
        this.image.setImageFill(imageFill);
    }

    @Override
    public void setImageAlignVertical(int imageAlignV) {
        this.image.setImageAlignVertical(imageAlignV);
    }

    @Override
    public void setImageAlignHorizontal(int imageAlignH) {
        this.image.setImageAlignHorizontal(imageAlignH);
    }

    @Override
    public int getPaddingRight() {
        return this.padding.getPaddingRight();
    }

    @Override
    public int getPaddingLeft() {
        return this.padding.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        return this.padding.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.padding.getPaddingBottom();
    }

    @Override
    public void setPaddingRight(int paddingRight) {
        this.padding.setPaddingRight(paddingRight);
    }

    @Override
    public void setPaddingLeft(int paddingLeft) {
        this.padding.setPaddingLeft(paddingLeft);
    }

    @Override
    public void setPaddingTop(int paddingTop) {
        this.padding.setPaddingTop(paddingTop);
    }

    @Override
    public void setPaddingBottom(int paddingBottom) {
        this.padding.setPaddingBottom(paddingBottom);
    }
}

