/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.dataset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.property.Property;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.JDBCSupportConnection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.dataset.DataSetMeta;
import net.hero.engine.data.resultset.ResultSet;
import net.hero.engine.data.resultset.ResultSetMem;

public class DataSetJDBC
implements DataSet,
Property {
    public static final String JDBC_PROPERTY_SQL = "jdbc-sql";
    private DataSetMeta datasetmeta = new DataSetMeta();
    private Connection connection = null;
    private String name = "";
    private String SQL = "";

    public DataSetJDBC(Connection connection, String name) {
        this.connection = connection;
        this.name = name;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSetMeta getDataSetMeta() {
        return this.datasetmeta;
    }

    @Override
    public ResultSet createResultSet(Map<String, String> parameterMap) {
        ResultSetMem rs = new ResultSetMem(this);
        if (!(this.getConnection() instanceof JDBCSupportConnection)) {
            return rs;
        }
        JDBCSupportConnection connectionJDBC = (JDBCSupportConnection)((Object)this.getConnection());
        Statement stJDBC = connectionJDBC.getJDBCStatement();
        if (stJDBC == null) {
            return rs;
        }
        java.sql.ResultSet rsJDBC = null;
        ResultSetMetaData metaJBC = null;
        String executeSQL = this.SQL;
        if (executeSQL.isEmpty()) {
            throw new IllegalArgumentException("SQL should never be null.");
        }
        executeSQL = this.compileSQL(executeSQL, parameterMap);
        try {
            rsJDBC = stJDBC.executeQuery(executeSQL);
            metaJBC = rsJDBC.getMetaData();
            while (rsJDBC.next()) {
                int nColumnCount = this.datasetmeta.getColumnCount();
                String[] data = new String[nColumnCount];
                int i = 1;
                while (i <= nColumnCount) {
                    data[i - 1] = rsJDBC.getString(i);
                    ++i;
                }
                rs.addString(data);
            }
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        return rs;
    }

    @Override
    public void setProperty(String name, String value) {
        if (name == null || name.isEmpty() || value == null) {
            return;
        }
        if ((name = name.toLowerCase()).equals(JDBC_PROPERTY_SQL)) {
            this.SQL = value;
        }
    }

    @Override
    public String getProperty(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if ((name = name.toLowerCase()).equals(JDBC_PROPERTY_SQL)) {
            return this.SQL;
        }
        return "";
    }

    @Override
    public Map<String, String> getAllProperty() {
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put(JDBC_PROPERTY_SQL, this.SQL);
        return mapProperty;
    }

    public String getSQL() {
        return this.SQL;
    }

    public String compileSQL(String SQL, Map<String, String> mapParameter) {
        if (mapParameter == null) {
            return SQL;
        }
        for (Map.Entry<String, String> entry : mapParameter.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            SQL = SQL.replace("{" + name + "}", value);
        }
        return SQL;
    }

    public void setSQL(String SQL) {
        this.SQL = SQL;
    }
}

