/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.dataset;

import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.property.Property;
import net.hero.engine.common.xml.XMLDocument;
import net.hero.engine.common.xml.XMLElement;
import net.hero.engine.common.xml.XMLElementList;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.XMLSupportConnection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.dataset.DataSetColumn;
import net.hero.engine.data.dataset.DataSetMeta;
import net.hero.engine.data.resultset.ResultSet;
import net.hero.engine.data.resultset.ResultSetMem;
import net.hero.engine.data.resultset.ResultSetNull;

public class DataSetXML
implements DataSet,
Property {
    public static final String XML_PROPERTY_ROOT = "xml-root";
    private DataSetMeta datasetmeta = new DataSetMeta();
    private Connection connection = null;
    private String name = "";
    private String rootPath = "";

    public DataSetXML(Connection connection, String name) {
        this.connection = connection;
        this.name = name;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSetMeta getDataSetMeta() {
        return this.datasetmeta;
    }

    @Override
    public ResultSet createResultSet(Map<String, String> parameterMap) {
        ResultSet resultset = ResultSetNull.NULL;
        if (this.rootPath.isEmpty()) {
            throw new IllegalArgumentException("XML root should never be null.");
        }
        if (!(this.getConnection() instanceof XMLSupportConnection)) {
            throw new IllegalArgumentException("Connection MAY shouldn't support XML.");
        }
        resultset = new ResultSetMem(this);
        return this.fillResultSet(resultset);
    }

    protected ResultSet fillResultSet(ResultSet resultset) {
        XMLSupportConnection connectionXML = (XMLSupportConnection)((Object)this.getConnection());
        XMLDocument xml = connectionXML.connectionXML();
        if (xml == null) {
            return resultset;
        }
        XMLElementList list = xml.selectNodes(this.rootPath);
        if (list == null || list.isNull()) {
            return resultset;
        }
        int i = 0;
        while (i < list.getLength()) {
            XMLElement element = list.getChild(i);
            int columnCount = this.datasetmeta.getColumnCount();
            String[] data = new String[columnCount];
            int index = 0;
            int column = 0;
            while (column < columnCount) {
                XMLElement dataElement;
                DataSetColumn datasetColumn = this.datasetmeta.getColumn(column);
                String xPath = datasetColumn.getXPath();
                if (xPath.isEmpty()) {
                    xPath = datasetColumn.getName();
                }
                if ((dataElement = element.selectSingleNode(xPath)) != null && !dataElement.isNull()) {
                    data[index] = dataElement.getText();
                }
                ++index;
                ++column;
            }
            resultset.addString(data);
            ++i;
        }
        return resultset;
    }

    @Override
    public void setProperty(String name, String value) {
        if (name == null || name.isEmpty() || value == null) {
            return;
        }
        if ((name = name.toLowerCase()).equals(XML_PROPERTY_ROOT)) {
            this.rootPath = value;
        }
    }

    @Override
    public String getProperty(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if ((name = name.toLowerCase()).equals(XML_PROPERTY_ROOT)) {
            return this.rootPath;
        }
        return "";
    }

    @Override
    public Map<String, String> getAllProperty() {
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put(XML_PROPERTY_ROOT, this.rootPath);
        return mapProperty;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }
}

