/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.control;

import java.awt.Color;
import net.hero.engine.base.BackGround;
import net.hero.engine.base.Line;
import net.hero.engine.base.Visible;
import net.hero.engine.common.context.Context;
import net.hero.engine.content.instance.InstanceShape;
import net.hero.engine.document.control.ControlCommon;
import net.hero.engine.document.control.InstanceInfo;
import net.hero.engine.style.StyleManager;
import net.hero.engine.style.conditional.ConditionalStyle;

public class ControlShape
extends ControlCommon
implements Visible,
BackGround,
Line {
    public static final String[] STYLE_FAMILYS = new String[]{"visible", "background", "line"};
    protected Visible visible = null;
    protected BackGround background = null;
    protected Line line = null;
    protected ConditionalStyle conditionalStyle = null;

    protected ControlShape() {
    }

    public static ControlShape createControl(StyleManager styleManager) {
        ControlShape control = new ControlShape();
        control.visible = styleManager.getDefaultStyleVisible();
        control.background = styleManager.getDefaultStyleBackGround();
        control.line = styleManager.getDefaultStyleLine();
        return control;
    }

    @Override
    public String getFamilyName() {
        return "shape";
    }

    @Override
    public InstanceInfo[] createInstance(Context ctx, StyleManager styleManager) {
        InstanceInfo[] listInstanceInfo = new InstanceInfo[]{new InstanceInfo()};
        InstanceShape instance = InstanceShape.createInstance(styleManager);
        listInstanceInfo[0].setInstance(instance);
        listInstanceInfo[0].setControl(this);
        return listInstanceInfo;
    }

    @Override
    public boolean getVisible() {
        return this.visible.getVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible.setVisible(visible);
    }

    @Override
    public Color getBackGroundColor() {
        return this.background.getBackGroundColor();
    }

    @Override
    public int getBackGroundStyle() {
        return this.background.getBackGroundStyle();
    }

    @Override
    public Color getBackGroundFillColor() {
        return this.background.getBackGroundFillColor();
    }

    @Override
    public int getBackGroundFillStyle() {
        return this.background.getBackGroundFillStyle();
    }

    @Override
    public void setBackGroundColor(Color backgoundColor) {
        this.background.setBackGroundColor(backgoundColor);
    }

    @Override
    public void setBackGroundStyle(int backgroundStyle) {
        this.background.setBackGroundStyle(backgroundStyle);
    }

    @Override
    public void setBackGroundFillColor(Color backgroundFillColor) {
        this.background.setBackGroundFillColor(backgroundFillColor);
    }

    @Override
    public void setBackGroundFillStyle(int backgroundFillStyle) {
        this.background.setBackGroundFillStyle(backgroundFillStyle);
    }

    @Override
    public Color getLineColor() {
        return this.line.getLineColor();
    }

    @Override
    public int getLineStyle() {
        return this.line.getLineStyle();
    }

    @Override
    public int getLineWidth() {
        return this.line.getLineWidth();
    }

    @Override
    public void setLineColor(Color color) {
        this.line.setLineColor(color);
    }

    @Override
    public void setLineStyle(int style) {
        this.line.setLineStyle(style);
    }

    @Override
    public void setLineWidth(int width) {
        this.line.setLineWidth(width);
    }
}

