/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.control;

import java.util.ArrayList;
import net.hero.engine.base.Visible;
import net.hero.engine.common.context.Context;
import net.hero.engine.content.instance.InstanceTable;
import net.hero.engine.document.control.ControlCommon;
import net.hero.engine.document.control.ControlTableCell;
import net.hero.engine.document.control.ControlTableCol;
import net.hero.engine.document.control.ControlTableRow;
import net.hero.engine.document.control.InstanceInfo;
import net.hero.engine.style.StyleManager;

public class ControlTable
extends ControlCommon
implements Visible {
    protected ArrayList<ControlTableCol> listCols = new ArrayList();
    protected ArrayList<ControlTableRow> listRows = new ArrayList();
    protected Visible visible = null;

    protected ControlTable() {
    }

    public static ControlTable createControl(StyleManager styleManager) {
        ControlTable control = new ControlTable();
        control.visible = styleManager.getDefaultStyleVisible();
        return control;
    }

    @Override
    public String getFamilyName() {
        return "table";
    }

    public ControlTableCol[] getColumns() {
        ControlTableCol[] columns = new ControlTableCol[this.listCols.size()];
        return this.listCols.toArray(columns);
    }

    public ControlTableRow[] getRows() {
        ControlTableRow[] rows = new ControlTableRow[this.listRows.size()];
        return this.listRows.toArray(rows);
    }

    @Override
    public InstanceInfo[] createInstance(Context ctx, StyleManager styleManager) {
        InstanceInfo[] listInstanceInfo = new InstanceInfo[]{new InstanceInfo()};
        InstanceTable instance = InstanceTable.createInstance(styleManager);
        listInstanceInfo[0].setInstance(instance);
        listInstanceInfo[0].setControl(this);
        instance.getRect().left = this.getRect().left;
        instance.getRect().top = this.getRect().top;
        if (instance != null) {
            for (ControlTableCol column : this.listCols) {
                instance.addColumn(column.createInstance(ctx, styleManager));
            }
            for (ControlTableRow row : this.listRows) {
                instance.addRow(row.createInstance(ctx, styleManager));
            }
        }
        instance.getRect().set(this.getRect());
        return listInstanceInfo;
    }

    public void addColumn(ControlTableCol controlTableCol) {
        if (controlTableCol == null) {
            throw new IllegalArgumentException("Cannot add a null ControlTableCol");
        }
        this.listCols.add(controlTableCol);
    }

    public void addRow(ControlTableRow controlTableRow) {
        if (controlTableRow == null) {
            throw new IllegalArgumentException("Cannot add a null ControlTableRow");
        }
        this.listRows.add(controlTableRow);
    }

    public int getColCount() {
        return this.listCols.size();
    }

    public int getRowCount() {
        return this.listRows.size();
    }

    public ControlTableCol getColumn(int columnIndex) {
        return this.listCols.get(columnIndex);
    }

    public ControlTableRow getRow(int rowIndex) {
        return this.listRows.get(rowIndex);
    }

    public ControlTableCell getCell(int rowIndex, int columnIndex) {
        ControlTableRow controlTableRow = this.getRow(rowIndex);
        if (controlTableRow != null) {
            return controlTableRow.getCell(columnIndex);
        }
        return null;
    }

    public ControlTableCell[] getCellList() {
        int totalCellCount = 0;
        int i = 0;
        while (i < this.listRows.size()) {
            totalCellCount += this.getRow(i).getCellCount();
            ++i;
        }
        ControlTableCell[] tableCells = new ControlTableCell[totalCellCount];
        totalCellCount = 0;
        int i2 = 0;
        while (i2 < this.listRows.size()) {
            ControlTableRow tableRow = this.getRow(i2);
            int j = 0;
            while (j < tableRow.getCellCount()) {
                tableCells[totalCellCount] = tableRow.getCell(j);
                ++totalCellCount;
                ++j;
            }
            ++i2;
        }
        return tableCells;
    }

    @Override
    public boolean getVisible() {
        return this.visible.getVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible.setVisible(visible);
    }
}

