/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.control;

import java.util.ArrayList;
import net.hero.engine.common.context.Context;
import net.hero.engine.content.instance.InstanceTableRow;
import net.hero.engine.document.control.ControlTableCell;
import net.hero.engine.style.StyleManager;

public class ControlTableRow {
    protected int height = 0;
    protected ArrayList<ControlTableCell> listCells = new ArrayList();

    public ControlTableRow() {
    }

    public ControlTableRow(int height) {
        this.height = height;
    }

    public InstanceTableRow createInstance(Context ctx, StyleManager styleManager) {
        InstanceTableRow instance = new InstanceTableRow();
        instance.setHeight(this.getHeight());
        for (ControlTableCell cell : this.listCells) {
            instance.addCell(cell.createInstanceCell(ctx, styleManager));
        }
        return instance;
    }

    public ControlTableCell[] getCells() {
        ControlTableCell[] instanceTableCells = new ControlTableCell[this.listCells.size()];
        return this.listCells.toArray(instanceTableCells);
    }

    public void addCell(ControlTableCell controlTableCell) {
        this.listCells.add(controlTableCell);
    }

    public ControlTableCell getCell(int columnIndex) {
        return this.listCells.get(columnIndex);
    }

    public int getCellCount() {
        return this.listCells.size();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

