/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.report;

import net.hero.engine.common.context.Context;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.field.FieldManager;
import net.hero.engine.data.resultset.ResultSet;
import net.hero.engine.document.Document;
import net.hero.engine.document.page.PageControl;
import net.hero.engine.processing.EngineCommandBuilder;
import net.hero.engine.processing.EngineCommandCollection;
import net.hero.engine.style.StyleManager;
import net.hero.engine.style.conditional.ConditionalStyleManager;

public class Report {
    protected Document document = null;
    protected FieldManager fieldManager = new FieldManager();
    protected ConditionalStyleManager conditionStyleManager = new ConditionalStyleManager();
    protected PageControl documentPage = new PageControl();
    protected Context context = new Context();
    protected String datasetName = "";

    public Report(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public PageControl getPage() {
        return this.documentPage;
    }

    public FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public ConditionalStyleManager getConditionalStyleManager() {
        return this.conditionStyleManager;
    }

    public Context getContext() {
        return this.context;
    }

    public String getDataSetName() {
        return this.datasetName;
    }

    public void setDataSetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public EngineCommandCollection createCommand(Context ctx, StyleManager styleManager) {
        EngineCommandCollection listCommand = new EngineCommandCollection();
        DataSet dataset = this.getDocument().getDataSet(this.getDataSetName());
        if (dataset == null && (dataset = this.getDocument().getDataSet("*")) == null) {
            return listCommand;
        }
        ResultSet resultset = dataset.createResultSet(null);
        this.context.setFieldManager(this.getFieldManager());
        this.context.setStyleManager(styleManager);
        EngineCommandBuilder commandBuilder = new EngineCommandBuilder();
        return commandBuilder.createCommand(this.context, resultset, this);
    }
}

