/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.export;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.Map;
import net.hero.engine.content.Content;
import net.hero.engine.content.instance.Instance;
import net.hero.engine.content.instance.InstanceGroup;
import net.hero.engine.content.instance.InstanceLabel;
import net.hero.engine.content.instance.InstanceShape;
import net.hero.engine.content.instance.InstanceTable;
import net.hero.engine.content.instance.InstanceTableCell;
import net.hero.engine.content.instance.InstanceTableCol;
import net.hero.engine.content.instance.InstanceTableRow;
import net.hero.engine.document.page.PageInstance;
import net.hero.engine.document.section.Section;
import net.hero.engine.export.Export;
import net.hero.engine.style.Style;

public class ExportXML
implements Export {
    @Override
    public void setProperty(String name, String value) {
    }

    @Override
    public String getProperty(String name) {
        return "";
    }

    @Override
    public void setProperties(Map<String, String> mapProperty) {
    }

    @Override
    public void export(Content content, OutputStream out) {
        Style[] styles;
        Style[] defaultStyles;
        if (content == null || out == null) {
            return;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"), 4096));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.println("<document>");
        pw.println("<global>");
        pw.println("<styles>");
        Style[] styleArray = defaultStyles = content.getGlobal().getStyleManager().getDefaultStyles();
        int n = defaultStyles.length;
        int n2 = 0;
        while (n2 < n) {
            Style defaultStyle = styleArray[n2];
            pw.print("<default-style ");
            pw.print("family='");
            pw.print(defaultStyle.getFamilyName());
            pw.print("'");
            Map<String, String> mapAttribute = defaultStyle.getAttributeStringMap();
            if (mapAttribute != null) {
                for (Map.Entry<String, String> entry : mapAttribute.entrySet()) {
                    String attributeName = entry.getKey();
                    String attributeValue = entry.getValue();
                    pw.print(" " + (String)attributeName);
                    pw.print("='");
                    pw.print(attributeValue);
                    pw.print("' ");
                }
            }
            pw.println("/>");
            ++n2;
        }
        Style[] styleArray2 = styles = content.getGlobal().getStyleManager().getStyles();
        int n3 = styles.length;
        n = 0;
        while (n < n3) {
            Style style = styleArray2[n];
            pw.print("<style ");
            pw.print("family='");
            pw.print(style.getFamilyName());
            pw.print("' ");
            pw.print("name='");
            pw.print(style.getName());
            pw.print("' ");
            Map<String, String> mapAttribute = style.getAttributeStringMap();
            if (mapAttribute != null) {
                for (Map.Entry entry : mapAttribute.entrySet()) {
                    String attributeName = (String)entry.getKey();
                    String attributeValue = (String)entry.getValue();
                    pw.print(" " + attributeName);
                    pw.print("='");
                    pw.print(attributeValue);
                    pw.print("' ");
                }
            }
            pw.print("/>");
            ++n;
        }
        pw.println("</styles>");
        pw.println("</global>");
        pw.println("<body>");
        PageInstance[] pages = content.getBody().getPages();
        if (pages != null) {
            PageInstance[] pageInstanceArray = pages;
            int n4 = pages.length;
            n3 = 0;
            while (n3 < n4) {
                PageInstance page = pageInstanceArray[n3];
                if (page != null) {
                    Formatter formatter = new Formatter();
                    formatter.format("\r\n<page   page-type='%s' page-direction='%s'  page-width='%d' page-height='%d' page-margin-left='%d'  page-margin-right='%d'    page-margin-top='%d' page-margin-bottom='%d' >\r\n", page.getPageType(), "portrait", page.getPageWidth(), page.getPageHeight(), page.getPageMarginLeft(), page.getPageMarginRight(), page.getPageMarginTop(), page.getPageMarginBottom());
                    pw.println(formatter.toString());
                    Instance[] instances = page.getInstances();
                    this.exportInstance(pw, content, instances, 0, 0);
                    pw.println("</page>");
                    pw.flush();
                }
                ++n3;
            }
        }
        pw.println("</body>");
        pw.println("</document>");
        pw.flush();
    }

    protected void exportInstance(PrintWriter pw, Content content, Instance[] instances, int offsetx, int offsety) {
        Instance[] instanceArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            Instance control = instanceArray[n2];
            if (control instanceof InstanceTable) {
                this.exportTable(pw, content, (InstanceTable)control, offsetx, offsety);
            } else if (control instanceof InstanceLabel) {
                this.exportLabel(pw, content, (InstanceLabel)control, offsetx, offsety);
            } else if (control instanceof InstanceGroup) {
                this.exportGroup(pw, content, (InstanceGroup)control, offsetx, offsety);
            } else if (control instanceof InstanceShape) {
                this.exportShape(pw, content, (InstanceShape)control, offsetx, offsety);
            }
            ++n2;
        }
    }

    protected void exportSection(PrintWriter pw, Content content, Section section) {
    }

    protected void exportGroup(PrintWriter pw, Content content, InstanceGroup group, int offsetx, int offsety) {
        this.exportInstance(pw, content, group.getAllInstance(), group.getRect().left + offsetx, group.getRect().top + offsety);
    }

    protected void exportTable(PrintWriter pw, Content content, InstanceTable instanceTable, int offsetx, int offsety) {
        InstanceTableRow[] instanceTableRows;
        InstanceTableCol[] instanceTableCols;
        Formatter formatter = new Formatter();
        formatter.format("\r\n<control control-type='table' x1='%d' y1='%d'>\r\n", instanceTable.getRect().left + offsetx, instanceTable.getRect().top + offsety);
        pw.print(formatter.toString());
        InstanceTableCol[] instanceTableColArray = instanceTableCols = instanceTable.getColumns();
        int n = instanceTableCols.length;
        int n2 = 0;
        while (n2 < n) {
            InstanceTableCol instanceTableCol = instanceTableColArray[n2];
            pw.print("<column width='");
            pw.print(instanceTableCol.getWidth());
            pw.print("'/>\r\n");
            ++n2;
        }
        InstanceTableRow[] instanceTableRowArray = instanceTableRows = instanceTable.getRows();
        int n3 = instanceTableRows.length;
        n = 0;
        while (n < n3) {
            InstanceTableCell[] instanceTableCells;
            InstanceTableRow instanceTableRow = instanceTableRowArray[n];
            pw.print("<row height='");
            pw.print(instanceTableRow.getHeight());
            pw.println("'>\r\n");
            InstanceTableCell[] instanceTableCellArray = instanceTableCells = instanceTableRow.getCells();
            int n4 = instanceTableCells.length;
            int n5 = 0;
            while (n5 < n4) {
                InstanceTableCell instanceTableCell = instanceTableCellArray[n5];
                pw.print("<cell ");
                pw.print("colspan='");
                pw.print(instanceTableCell.getColSpan());
                pw.print("' ");
                pw.print("rowspan='");
                pw.print(instanceTableCell.getRowSpan());
                pw.print("' ");
                pw.print(instanceTableCell.styleToString());
                pw.print("><![CDATA[");
                pw.print(instanceTableCell.getText());
                pw.print("]]></cell>");
                ++n5;
            }
            pw.println("</row>");
            ++n;
        }
        pw.println("</control>");
    }

    protected void exportLabel(PrintWriter pw, Content content, InstanceLabel instanceLabel, int offsetx, int offsety) {
        Formatter formatter = new Formatter();
        formatter.format("\r\n<control control-type='textbox' x1='%d' y1='%d' width='%d' height='%d'", instanceLabel.getRect().left + offsetx, instanceLabel.getRect().top + offsety, instanceLabel.getRect().width(), instanceLabel.getRect().height());
        pw.print(formatter.toString());
        pw.print(" ");
        pw.print(instanceLabel.styleToString());
        pw.print(" ");
        pw.print("><![CDATA[");
        pw.print(instanceLabel.getText());
        pw.print("]]></control>");
    }

    protected void exportShape(PrintWriter pw, Content content, InstanceShape instanceShape, int offsetx, int offsety) {
        Formatter formatter = new Formatter();
        formatter.format("\r\n<control control-type='shape' x1='%d' y1='%d' width='%d' height='%d'", instanceShape.getRect().left + offsetx, instanceShape.getRect().top + offsety, instanceShape.getRect().width(), instanceShape.getRect().height());
        pw.print(formatter.toString());
        pw.print(" ");
        pw.print(" ");
        pw.print(">");
        pw.print("</control>");
    }
}

