/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.awt.Color;
import net.hero.engine.base.Font;
import net.hero.engine.style.EnumAlignHorizontal;
import net.hero.engine.style.EnumAlignVertical;
import net.hero.engine.style.Style;

public class FontStyle
extends Style
implements Font {
    public static final String FONT_NAME = "font-name";
    public static final String FONT_COLOR = "font-color";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_STRIKE = "font-strike";
    public static final String FONT_UNDERLINE = "font-underline";
    public static final String FONT_ITALIC = "font-italic";
    public static final String FONT_BOLD = "font-bold";
    public static final String FONT_WORDWRAP = "font-wordwrap";
    public static final String FONT_HORIZONTAL_ALIGN = "font-horizontal-align";
    public static final String FONT_VERTICAL_ALIGN = "font-vertical-align";
    public static final String[] ATTRIBUTE_NAMES = new String[]{"font-name", "font-color", "font-size", "font-strike", "font-underline", "font-italic", "font-bold", "font-wordwrap", "font-horizontal-align", "font-vertical-align"};

    public FontStyle() {
        this.attributes.addAttribute(FONT_NAME, "\uc0c8\uad74\ub9bc");
        this.attributes.addAttribute(FONT_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(FONT_SIZE, 9);
        this.attributes.addAttribute(FONT_STRIKE, false);
        this.attributes.addAttribute(FONT_UNDERLINE, false);
        this.attributes.addAttribute(FONT_ITALIC, false);
        this.attributes.addAttribute(FONT_BOLD, false);
        this.attributes.addAttribute(FONT_WORDWRAP, true);
        this.attributes.addAttribute(FONT_HORIZONTAL_ALIGN, EnumAlignHorizontal.LEFT);
        this.attributes.addAttribute(FONT_VERTICAL_ALIGN, EnumAlignVertical.TOP);
    }

    @Override
    public String getFamilyName() {
        return "font";
    }

    @Override
    public String[] getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public String getFontName() {
        return (String)this.getAttribute(FONT_NAME).getValue();
    }

    @Override
    public Color getFontColor() {
        return (Color)this.getAttribute(FONT_COLOR).getValue();
    }

    @Override
    public int getFontSize() {
        return (Integer)this.getAttribute(FONT_SIZE).getValue();
    }

    @Override
    public boolean getFontStrike() {
        return (Boolean)this.getAttribute(FONT_STRIKE).getValue();
    }

    @Override
    public boolean getFontUnderline() {
        return (Boolean)this.getAttribute(FONT_UNDERLINE).getValue();
    }

    @Override
    public boolean getFontItalic() {
        return (Boolean)this.getAttribute(FONT_ITALIC).getValue();
    }

    @Override
    public boolean getFontBold() {
        return (Boolean)this.getAttribute(FONT_BOLD).getValue();
    }

    @Override
    public boolean getFontWordwrap() {
        return (Boolean)this.getAttribute(FONT_WORDWRAP).getValue();
    }

    @Override
    public int getFontHorizontalAlign() {
        return this.getAttribute(FONT_HORIZONTAL_ALIGN).toInt();
    }

    @Override
    public int getFontVerticalAlign() {
        return this.getAttribute(FONT_VERTICAL_ALIGN).toInt();
    }

    @Override
    public void setFontName(String name) {
        this.getAttribute(FONT_NAME).setValue(name);
    }

    @Override
    public void setFontColor(Color color) {
        this.getAttribute(FONT_COLOR).setValue(color);
    }

    @Override
    public void setFontSize(int size) {
        this.getAttribute(FONT_SIZE).setValue(size);
    }

    @Override
    public void setFontStrike(boolean strike) {
        this.getAttribute(FONT_STRIKE).setValue(strike);
    }

    @Override
    public void setFontUnderline(boolean underline) {
        this.getAttribute(FONT_UNDERLINE).setValue(underline);
    }

    @Override
    public void setFontItalic(boolean italic) {
        this.getAttribute(FONT_ITALIC).setValue(italic);
    }

    @Override
    public void setFontBold(boolean bold) {
        this.getAttribute(FONT_BOLD).setValue(bold);
    }

    @Override
    public void setFontWordwrap(boolean wordwrap) {
        this.getAttribute(FONT_WORDWRAP).setValue(wordwrap);
    }

    @Override
    public void setFontHorizontalAlign(int align) {
        this.getAttribute(FONT_HORIZONTAL_ALIGN).setEnum(align);
    }

    @Override
    public void setFontVerticalAlign(int align) {
        this.getAttribute(FONT_VERTICAL_ALIGN).setEnum(align);
    }
}

