/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.awt.Color;
import net.hero.engine.base.Line;
import net.hero.engine.style.EnumLineStyle;
import net.hero.engine.style.Style;

public class LineStyle
extends Style
implements Line {
    public static final String LINE_COLOR = "line-color";
    public static final String LINE_STYLE = "line-style";
    public static final String LINE_WIDTH = "line-width";
    public static final String[] ATTRIBUTE_NAMES = new String[]{"line-color", "line-style", "line-width"};

    public LineStyle() {
        this.attributes.addAttribute(LINE_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(LINE_STYLE, EnumLineStyle.SOLD);
        this.attributes.addAttribute(LINE_WIDTH, 1);
    }

    @Override
    public String getFamilyName() {
        return "line";
    }

    @Override
    public String[] getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Color getLineColor() {
        return (Color)this.getAttribute(LINE_COLOR).getValue();
    }

    @Override
    public int getLineStyle() {
        return this.getAttribute(LINE_STYLE).toInt();
    }

    @Override
    public int getLineWidth() {
        return (Integer)this.getAttribute(LINE_WIDTH).getValue();
    }

    @Override
    public void setLineColor(Color color) {
        this.getAttribute(LINE_COLOR).setValue(color);
    }

    @Override
    public void setLineStyle(int style) {
        this.getAttribute(LINE_STYLE).setEnum(style);
    }

    @Override
    public void setLineWidth(int width) {
        this.getAttribute(LINE_WIDTH).setValue(width);
    }
}

