/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.util.HashMap;
import java.util.Map;
import net.hero.engine.style.Attribute;
import net.hero.engine.style.AttributeCollection;
import net.hero.engine.style.FactoryStyle;

public abstract class Style {
    protected String name = "";
    protected AttributeCollection attributes = new AttributeCollection();

    public String getFamilyName() {
        return "background";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getAttributeNames() {
        return null;
    }

    public Attribute getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public Attribute[] getAttributes() {
        return this.attributes.getAttributes();
    }

    public Attribute setAttribute(String name, Object value) {
        Attribute attribute = this.getAttribute(name);
        if (attribute != null) {
            attribute.setValue(value);
        }
        return attribute;
    }

    public Style clone() {
        Attribute[] attributes;
        Style style = FactoryStyle.getInstance().createStyle(this.getFamilyName());
        Attribute[] attributeArray = attributes = this.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            style.getAttribute(attribute.getName()).setValue(attribute.getValue());
            ++n2;
        }
        return style;
    }

    public void attach(Style style) {
        Attribute[] attributes;
        Attribute[] attributeArray = attributes = style.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            this.getAttribute(attribute.getName()).setValue(attribute.getValue());
            ++n2;
        }
    }

    public boolean equals(Style style) {
        if (this == style) {
            return true;
        }
        if (style == null || !this.getClass().equals(style.getClass())) {
            return false;
        }
        return this.equals(style.getAttributes());
    }

    public boolean equals(Attribute[] attributes) {
        Attribute[] attributesThat;
        if (attributes == null) {
            return false;
        }
        Attribute[] attributesThis = this.getAttributes();
        if (attributesThis.length != (attributesThat = attributes).length) {
            return false;
        }
        int i = 0;
        while (i < attributesThis.length) {
            Attribute attrThis = attributesThis[i];
            Attribute attrThat = attributesThat[i];
            if (!attrThis.equals(attrThat)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Map<String, String> getAttributeStringMap() {
        Attribute[] attributes = this.getAttributes();
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        HashMap<String, String> mapAttributeString = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.length) {
            Attribute attr = attributes[i];
            mapAttributeString.put(attr.getName(), attr.getValueString());
            ++i;
        }
        return mapAttributeString;
    }
}

