/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.hero.engine.style.Attribute;
import net.hero.engine.style.AttributeCollection;
import net.hero.engine.style.BackGroundStyle;
import net.hero.engine.style.BorderStyle;
import net.hero.engine.style.FactoryStyle;
import net.hero.engine.style.FontStyle;
import net.hero.engine.style.ImageStyle;
import net.hero.engine.style.LineStyle;
import net.hero.engine.style.PaddingStyle;
import net.hero.engine.style.PageStyle;
import net.hero.engine.style.SectionStyle;
import net.hero.engine.style.Style;
import net.hero.engine.style.VisibleStyle;

public class StyleManager {
    private BackGroundStyle defaultStyleBackGround = new BackGroundStyle();
    private BorderStyle defaultStyleBorder = new BorderStyle();
    private FontStyle defaultStyleFont = new FontStyle();
    private ImageStyle defaultStyleImage = new ImageStyle();
    private LineStyle defaultStyleLine = new LineStyle();
    private PaddingStyle defaultStylePadding = new PaddingStyle();
    private PageStyle defaultStylePage = new PageStyle();
    private SectionStyle defaultStyleSection = new SectionStyle();
    private VisibleStyle defaultStyleVisible = new VisibleStyle();
    protected Map<String, ArrayList<Style>> mapStyles = new HashMap<String, ArrayList<Style>>();

    public BackGroundStyle getDefaultStyleBackGround() {
        return this.defaultStyleBackGround;
    }

    public BorderStyle getDefaultStyleBorder() {
        return this.defaultStyleBorder;
    }

    public FontStyle getDefaultStyleFont() {
        return this.defaultStyleFont;
    }

    public ImageStyle getDefaultStyleImage() {
        return this.defaultStyleImage;
    }

    public LineStyle getDefaultStyleLine() {
        return this.defaultStyleLine;
    }

    public PaddingStyle getDefaultStylePadding() {
        return this.defaultStylePadding;
    }

    public PageStyle getDefaultStylePage() {
        return this.defaultStylePage;
    }

    public SectionStyle getDefaultStyleSection() {
        return this.defaultStyleSection;
    }

    public VisibleStyle getDefaultStyleVisible() {
        return this.defaultStyleVisible;
    }

    public Style[] getDefaultStyles() {
        Style[] defaultStyles = new Style[]{this.defaultStyleBackGround, this.defaultStyleBorder, this.defaultStyleFont, this.defaultStyleImage, this.defaultStyleLine, this.defaultStylePadding, this.defaultStylePage, this.defaultStyleSection, this.defaultStyleVisible};
        return defaultStyles;
    }

    public Style getDefaultStyle(String family) {
        Style[] defaultStyles;
        Style[] styleArray = defaultStyles = this.getDefaultStyles();
        int n = defaultStyles.length;
        int n2 = 0;
        while (n2 < n) {
            Style defaultStyle = styleArray[n2];
            if (defaultStyle.getFamilyName().equalsIgnoreCase(family)) {
                return defaultStyle;
            }
            ++n2;
        }
        return null;
    }

    public Style[] getStyles() {
        ArrayList list = new ArrayList();
        for (Map.Entry<String, ArrayList<Style>> entry : this.mapStyles.entrySet()) {
            list.addAll(entry.getValue());
        }
        Style[] arrayStyleAll = new Style[list.size()];
        return list.toArray(arrayStyleAll);
    }

    public Style getStyle(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, ArrayList<Style>> entry : this.mapStyles.entrySet()) {
            ArrayList<Style> list = entry.getValue();
            for (Style style : list) {
                if (!style.getName().equalsIgnoreCase(name)) continue;
                return style;
            }
        }
        return null;
    }

    public Style getStyle(String family, String name) {
        if (family == null || family.isEmpty()) {
            return null;
        }
        if (name == null || name.isEmpty()) {
            return null;
        }
        ArrayList<Style> list = this.mapStyles.get(family);
        if (list != null) {
            for (Style style : list) {
                if (!style.getName().equalsIgnoreCase(name)) continue;
                return style;
            }
        }
        return null;
    }

    public Style createStyle(String family, String name) {
        if (family == null || family.isEmpty()) {
            return null;
        }
        if (name == null || name.isEmpty()) {
            return null;
        }
        Style style = this.getStyle(family, name);
        if (style == null && (style = FactoryStyle.getInstance().createStyle(family)) != null) {
            style.setName(name);
            ArrayList<Style> list = this.mapStyles.get(family);
            if (list == null) {
                list = new ArrayList();
                this.mapStyles.put(family, list);
            }
            list.add(style);
        }
        return style;
    }

    public Style createStyle(Style style) {
        Style changeStyle2;
        if (style == null) {
            return null;
        }
        String family = style.getFamilyName();
        ArrayList<Style> list = this.mapStyles.get(family);
        if (list != null) {
            for (Style changeStyle2 : list) {
                if (!changeStyle2.equals(style)) continue;
                return changeStyle2;
            }
        } else {
            list = new ArrayList();
            this.mapStyles.put(family, list);
        }
        changeStyle2 = style.clone();
        list.add(changeStyle2);
        return changeStyle2;
    }

    public Style createStyle(Style style, Attribute changeAttribute) {
        Style changeStyle2;
        String family = style.getFamilyName();
        Attribute[] attributes = style.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            Attribute attribute = attributes[i];
            if (attribute.getName().equalsIgnoreCase(changeAttribute.getName())) {
                attributes[i] = changeAttribute;
                break;
            }
            ++i;
        }
        ArrayList<Style> list = this.mapStyles.get(family);
        if (list != null) {
            for (Style changeStyle2 : list) {
                if (!changeStyle2.equals(attributes)) continue;
                return changeStyle2;
            }
        } else {
            list = new ArrayList();
            this.mapStyles.put(family, list);
        }
        changeStyle2 = style.clone();
        changeStyle2.setAttribute(changeAttribute.getName(), changeAttribute.getValue());
        list.add(changeStyle2);
        return changeStyle2;
    }

    public Style createStyle(Style style, AttributeCollection listAttribute) {
        String family = style.getFamilyName();
        Attribute[] attributeOld = style.getAttributes();
        Attribute[] attributeArray = attributeOld;
        int n = attributeOld.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            Attribute attributeold = listAttribute.getAttribute(attribute.getName());
            if (attributeold == null) {
                listAttribute.add(attribute.clone());
            }
            ++n2;
        }
        ArrayList<Style> list = this.mapStyles.get(family);
        if (list != null) {
            for (Style changeStyle : list) {
                if (!changeStyle.equals(listAttribute.getAttributes())) continue;
                return changeStyle;
            }
        } else {
            list = new ArrayList();
            this.mapStyles.put(family, list);
        }
        Style changeStyle = style.clone();
        for (Attribute attribute : listAttribute) {
            changeStyle.setAttribute(attribute.getName(), attribute.getValue());
        }
        list.add(changeStyle);
        return changeStyle;
    }
}

