/*
 * @author Choi Dae-Sung @ D&SOFT
 * @version 2.0, 08/06/17
 *
 * function	: description
 */
import java.lang.*;
import java.util.*;
import java.io.*;

class CSCP
{
	public static int CSCP_VERSION_SIZE = 7;
	public static int CSCP_BODYLEN_SIZE = 6;

	public static String read(BufferedInputStream bis) throws IOException
	{
		byte[] version = new byte[CSCP_VERSION_SIZE];
		byte[] bodylen = new byte[CSCP_BODYLEN_SIZE];
		byte[] body = new byte[0];

		bis.read(version, 0, CSCP_VERSION_SIZE);
		bis.read(bodylen, 0, CSCP_BODYLEN_SIZE);
		int ibodylen = Integer.valueOf((new String(bodylen)).trim());
		if (ibodylen > 0)
		{
			body = new byte[ibodylen];
			bis.read(body, 0, ibodylen);
		}
		return new String(body);
	}

	public static String build(String cscpstr)
	{
		String capsule = "CSCP1.0";
		capsule = capsule + String.format("%6d", cscpstr.getBytes().length);
		capsule = capsule + cscpstr;
		return capsule;
	}
}
