<?php

/**
 * CoolSMS CSCM2 PHP SMS Class
 *
 * Copyright (C) 2008, D&SOFT
 * Cool Supporter <help@coolsms.co.kr>
 */
include_once("tbsp.php");

function coolsms_spacing($text, $length) 
{
	$text = substr($text, 0, $length);
	$fmt = "%-" . $length . "s";
	$text = sprintf($fmt, $text);

	return $text;
}

function coolsms_cutout($msg, $limit) 
{
	$msg = substr($msg, 0, $limit);

	for ($i = $limit - 1; $i > 1; $i--) 
	{	 
		if (ord(substr($msg,$i,1)) < 128) break;
	}

	$msg = substr($msg, 0, $limit - ($limit - $i + 1) % 2);

	return $msg;
}

function coolsms_validate($dest, $datetime) 
{
	$dest = eregi_replace("[^0-9]", "", $dest);

	if (strlen($dest) < 10 || strlen($dest) > 11) 
		return "Źȣ  ʽϴ.";


	$prefix = substr($dest, 0, 3);
	if (eregi("[^0-9]", $prefix) 
		|| ($prefix!='010' 
		&& $prefix!='011' 
		&& $prefix!='016' 
		&& $prefix!='017' 
		&& $prefix!='018' 
		&& $prefix!='019')
	) return "Źȣ  ڸ  ʽϴ.";

	$datetime = eregi_replace("[^0-9]", "", $datetime);
	if ($datetime) {
		if (
			!checkdate(substr($datetime, 4, 2)
				,substr($datetime, 6, 2)
				,substr($datetime, 0, 4)
			)
		) return "೯¥  ʽϴ.";

		if (
			substr($datetime,8,2) > 23 || substr($datetime,10,2) > 59
		) return "ð  ʽϴ.";
	}
}

function coolsms_keygen()
{
	$randval = rand(100000, 999999);
	$usec = explode(" ", microtime());
	$str_usec = str_replace(".", "", strval($usec[0]));
	$str_usec = substr($str_usec, 0, 6);
	return date("YmdHis") . $str_usec . $randval;
}

class coolsms {
	var $TIME_LIMIT_SECS = 360;
	var $VERSION_STR = "TBSP/1.0";

	var $userid;
	var $passwd;

	var $ipaddr;
	var $port;

	var $msgl;
	var $result;

	var $errmsg;

	var $sockfp;

	function coolsms()
	{
       		$this->ipaddr = "210.109.102.114";
       		$this->port = 7803;
       		$this->msgl = array();
		$this->result = array();
		$this->errmsg = "";

	}

	function connect()
	{
		$this->sockfp = fsockopen($this->ipaddr, $this->port);
		if (!$this->sockfp) 
		{
			$this->errmsg = "   ϴ.";
			return false;
		}
		set_time_limit($this->TIME_LIMIT_SECS);
	}

	function disconnect()
	{
		fclose($this->sockfp);
	}

	function setuser($userid, $passwd, $crypt="MD5") 
	{
		$this->userid = $userid;
		$this->passwd = $passwd;
		$this->crypt = $crypt;
	}

	function setcrypt($crypt="MD5")
	{
		$this->crypt = $crypt;
	}

	function emptyall() 
	{
		$this->msgl = array();
	}

	function getres() 
	{
		return $this->result;
	}

	function printr()
	{
		foreach($this->result as $rs)
		{
			echo "Called Number: {$rs["CALLED-NUMBER"]}<br />";
			echo "Message ID: {$rs["MESSAGE-ID"]}<br />";
			echo "Result Code: {$rs["RESULT-CODE"]}<br />";
			echo "Result Message: {$rs["RESULT-MESSAGE"]}<br />";
		}
	}

	function errordetected()
	{
		if ($this->errmsg != "")
			return true;
		return false;
	}

	function lasterror()
	{
		return $this->errmsg;
	}

	function add($rcvnum, $callback, $msg, $callname="", $reservdate="", $msgid="") 
	{
		$errmsg = coolsms_validate($rcvnum, $reservdate);
		if ($errmsg) {
		       $this->errmsg = $errmsg;
		       return false;
		}

		if (eregi("[^0-9]",$callback)) 
		{
			$this->errmsg = "ȸ ȭȣ  ʽϴ.";
			return false;
		}

		$tbsp = array();

		$tbsp["VERSION"] = $this->VERSION_STR;
		$tbsp["COMMAND"] = "SEND";
		$tbsp["MESSAGE"] = $msg;
		if ($msgid != "")
			$tbsp["MESSAGE-ID"] = $msgid;
		$tbsp["CALLED-NUMBER"] = $rcvnum;
		$tbsp["CALLING-NUMBER"] = $callback;
		if ($callname != "")
			$tbsp["CALLED-NAME"] = $callname;
		if ($reservdate != "")
			$tbsp["RESERVE-DATE"] = $reservdate;
		if ($this->crypt == "MD5")
		{
			$tbsp["CRYPT-METHOD"] = "MD5";
			$passwd = md5($this->passwd);
		} else {
			$passwd = $this->passwd;
		}
		$tbsp["AUTH-ID"] = $this->userid;
		$tbsp["AUTH-PASS"] = $passwd;
		$version = "Unknown";
		if (function_exists("phpversion"))
			$version = phpversion();
		$language = "PHP-" . $version;
		$tbsp["LANGUAGE"] = $language;

		$this->msgl[] = cscp_build(tbsp_build($tbsp));

		return true;
	}

	function send() 
	{

		$tbspstr = "";
		foreach($this->msgl as $req) {
			fputs($this->sockfp, $req);

			$tbspstr = cscp_read($this->sockfp);
			if (!$tbspstr)
			{
				echo "cscp_read error";
				continue;
			}
			$tbsp = tbsp_parse($tbspstr);
			if (!$tbsp)
			{
				echo "tbsp_parse error";
				continue;
			}

			$this->result[] = $tbsp;
		}
		return true;
	}

	function credits()
	{
		$tbsp = array();
		$tbsp["VERSION"] = $this->VERSION_STR;
		$tbsp["COMMAND"] = "CHECK-CREDITS";
		if ($this->crypt == "MD5")
		{
			$tbsp["CRYPT-METHOD"] = "MD5";
			$passwd = md5($this->passwd);
		} else {
			$passwd = $this->passwd;
		}
		$tbsp["AUTH-ID"] = $this->userid;
		$tbsp["AUTH-PASS"] = $passwd;
		$cscp_str = cscp_build(tbsp_build($tbsp));

		fputs($this->sockfp, $cscp_str);

		$tbspstr = cscp_read($this->sockfp);
		if (!$tbspstr)
		{
			echo "cscp_read error";
		}
		$ack = tbsp_parse($tbspstr);
		if (!$ack)
		{
			echo "tbsp_parse error";
		}

		return $ack;
	}

	/**
	 * STATUS
	 * RESULT-CODE 
	 * RESULT-MESSAGE
	 */
	function rcheck($msgid)
	{
		$tbsp = array();
		$tbsp["VERSION"] = $this->VERSION_STR;
		$tbsp["COMMAND"] = "CHECK-RESULT";
		if ($this->crypt == "MD5")
		{
			$tbsp["CRYPT-METHOD"] = "MD5";
			$passwd = md5($this->passwd);
		} else {
			$passwd = $this->passwd;
		}
		$tbsp["AUTH-ID"] = $this->userid;
		$tbsp["AUTH-PASS"] = $passwd;
		$tbsp["MESSAGE-ID"] = $msgid;
		$cscp_str = cscp_build(tbsp_build($tbsp));


		fputs($this->sockfp, $cscp_str);

		$tbspstr = cscp_read($this->sockfp);

		if (!$tbspstr)
		{
			echo "cscp_read error";
		}
		$tbsp = tbsp_parse($tbspstr);
		if (!$tbsp)
		{
			echo "tbsp_parse error";
		}

		return $tbsp;

	}
}
?>
