
/*
 * Copyright (C) 2008, D&SOFT
 * Choi Dae-Sung <diver@coolsms.co.kr>
 */

#include "stdafx.h"
#include "SocketTCP.h"
#include <atlconv.h>


static int Winsock_startup(void)
{
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;

	wVersionRequested = MAKEWORD( 2, 2 );

	err = WSAStartup( wVersionRequested, &wsaData );

	if ( err != 0 ) {
		/* Tell the user that we could not find a usable */
		/* WinSock DLL.                                  */
		return -1;
	}

	/* Confirm that the WinSock DLL supports 2.2.*/
	/* Note that if the DLL supports versions greater    */
	/* than 2.2 in addition to 2.2, it will still return */
	/* 2.2 in wVersion since that is the version we      */
	/* requested.                                        */
	if ( LOBYTE( wsaData.wVersion ) != 2 ||
				HIBYTE( wsaData.wVersion ) != 2 ) {
		/* Tell the user that we could not find a usable */
		/* WinSock DLL.                                  */
		::WSACleanup( );
		return -1;
	}

	return 0;
}

static void Winsock_cleanup(void)
{
	::WSACleanup( );
}

// CSocketTCP

STDMETHODIMP CSocketTCP::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ISocketTCP
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CSocketTCP::OnStartPage (IUnknown* pUnk)  
{
	if(!pUnk)
		return E_POINTER;

	CComPtr<IScriptingContext> spContext;
	HRESULT hr;

	// Get the IScriptingContext Interface
	hr = pUnk->QueryInterface(__uuidof(IScriptingContext), (void **)&spContext);
	if(FAILED(hr))
		return hr;

	// Get Request Object Pointer
	hr = spContext->get_Request(&m_piRequest);
	if(FAILED(hr))
	{
		return hr;
	}

	// Get Response Object Pointer
	hr = spContext->get_Response(&m_piResponse);
	if(FAILED(hr))
	{
		m_piRequest.Release();
		return hr;
	}
	
	// Get Server Object Pointer
	hr = spContext->get_Server(&m_piServer);
	if(FAILED(hr))
	{
		m_piRequest.Release();
		m_piResponse.Release();
		return hr;
	}
	
	// Get Session Object Pointer
	hr = spContext->get_Session(&m_piSession);
	if(FAILED(hr))
	{
		m_piRequest.Release();
		m_piResponse.Release();
		m_piServer.Release();
		return hr;
	}

	// Get Application Object Pointer
	hr = spContext->get_Application(&m_piApplication);
	if(FAILED(hr))
	{
		m_piRequest.Release();
		m_piResponse.Release();
		m_piServer.Release();
		m_piSession.Release();
		return hr;
	}
	m_bOnStartPageCalled = TRUE;

	Winsock_startup();

	tcp.init();

	return S_OK;
}

STDMETHODIMP CSocketTCP::OnEndPage ()  
{
	m_bOnStartPageCalled = FALSE;
	// Release all interfaces
	m_piRequest.Release();
	m_piResponse.Release();
	m_piServer.Release();
	m_piSession.Release();
	m_piApplication.Release();

	if (tcp.is_connected())
		tcp.close();
	Winsock_cleanup();

	return S_OK;
}

STDMETHODIMP CSocketTCP::Connect(BSTR host, USHORT port, VARIANT_BOOL* retval)
{
	USES_CONVERSION;

	*retval = tcp.connect(OLE2A(host), port);
	return S_OK;
}

STDMETHODIMP CSocketTCP::SendText(BSTR data, VARIANT_BOOL* retval)
{
	USES_CONVERSION;

	size_t res = tcp.send(OLE2A(data));

	if (res > 0)
		*retval = true;
	else
		*retval = false;

	return S_OK;
}

STDMETHODIMP CSocketTCP::GetText(USHORT bytes, BSTR* retval)
{
	USES_CONVERSION;

	char *buf;
	int res;

	buf = (char *)calloc(1, bytes+1);

	res = tcp.recv(bytes, buf);
	buf[res] = 0;

	if (res > 0)
		*retval = SysAllocString(A2OLE(buf));

	free(buf);

	return S_OK;
}
