#ifndef __tcpconn_h__
#define __tcpconn_h__

#include <winsock2.h>
#include <string>
#include <io.h>

typedef unsigned int uint32_t;
typedef unsigned short int uint16_t;

class tcpconn
{
	public:
		tcpconn();
		tcpconn(int sockfd);
		~tcpconn();

		bool init();
		bool getaddr32(const std::string & saddr, u_long & addr);
		//void setnonblock();
		bool connect(const std::string & ipaddr, const uint16_t port);
		void close() { closesocket(sockfd); connected = false; }
		int send(const std::string & packet) { return send(packet.c_str(), packet.length()); }
		int send(const void *data, const size_t len);
		int recv(const int len, char *buf);
		bool listen(const std::string & ipaddr, int port);
		SOCKET accept();
		SOCKET getsock() const { return sockfd; }
		bool is_connected() const { return connected; }
		bool is_disconnected() const { return !connected; }

	private:
		SOCKET sockfd;
		bool connected;

};

#endif /* __tcpconn_h__ */
