

import java.awt.FontMetrics;


public class LayoutVisitor implements CuteCParserVisitor {

    /* (non-Javadoc)
     * @see CuteCParserVisitor#visit(ASTLHExpression, java.lang.Object)
     */
    public Object visit(ASTLHExpression node, Object data) {
        return visit((ASTPrimaryExpression)node,data);
    }

    public Object visit(ASTArrayInitializer node, Object data) {
        return layoutArray("Arr.Init.",node.children);
    }

    public Object visit(ASTAdditiveExpression node, Object data) {
        return layoutArray("Add.Exp.",node.children);        
    }

    public Object visit(ASTAssignment node, Object data) {
        return layoutBinary("Assign",node.children[0],node.children[1]);
    }

    public Object visit(ASTBlockStatement node, Object data) {
        return layoutArray("BlockSt.",node.children);
    }

    public Object visit(ASTCastExpression node, Object data) {
        return null;
    }

    public Object visit(ASTCastLookahead node, Object data) {
        return null;
    }

    public Object visit(ASTCompoundSt node, Object data) {
        return layoutArray("CompoundSt",node.children);
    }

    public Object visit(ASTConditionalAndExpression node, Object data) {
        return layoutArray("Cond.AndExp.",node.children);
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        return layoutArray("Con.Expr.",node.children);
    }

    public Object visit(ASTConditionalOrExpression node, Object data) {
        return layoutArray("Cond.OrExp.",node.children);
    }

    public Object visit(ASTConditionalSt node, Object data) {
        return layoutArray("Cond.St.",node.children);
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        return layoutArray("Cond.EqualExp.",node.children);    }

    public Object visit(ASTExpression node, Object data) {
        return layoutUnary("Expression",node.children[0]);
    }

    public Object visit(ASTFormalParameter node, Object data) {
        return layoutBinary("Parameter",node.children[0],node.children[1]);
    }

    public Object visit(ASTFormalParameters node, Object data) {
        return layoutArray("FormalParameters",node.children);
    }

    public Object visit(ASTFunctionDeclaration node, Object data) {
        return layoutArray("Function",node.children);
    }

    public Object visit(ASTIdentifier node, Object data) {
        return layoutNullary(node.spelling);
    }

    public Object visit(ASTLiteral node, Object data) {
        return layoutNullary(node.spelling);
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        return layoutArray("LocalVar.Dec.",node.children);
    }

    public Object visit(ASTMultiplicativeExpression node, Object data) {
        return layoutArray("Mul.Exp.",node.children);    }

    public Object visit(ASTName node, Object data) {
        return layoutUnary("Name",node.children[0]);
    }

    public Object visit(ASTPrimaryExpression node, Object data) {
        return layoutArray("Pri.Exp.",node.children);
    }

    public Object visit(ASTPrimaryPrefix node, Object data) {
        return layoutUnary("Pri.Pre.",node.children[0]);
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        return layoutArray("Pri.Suf.",node.children);
    }

    public Object visit(ASTPrimitiveTypeLookahead node, Object data) {
        return null;
    }

    public Object visit(ASTProgramDeclaration node, Object data) {
        return layoutArray("ProgramDecl", node.children);
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        return layoutArray("Rel.Exp.",node.children);    }

    public Object visit(ASTStatement node, Object data) {
        return layoutArray("Statement",node.children);
    }

    public Object visit(ASTType node, Object data) {
        String ret = new String();
        switch ( node.type ){
        case ASTType.T_INT:
            ret = "int";
            break;
        case ASTType.T_CHAR:
            ret = "char";
            break;
        case ASTType.T_BOOLEAN:
            ret ="boolean";
            break;
        case ASTType.T_FLOAT:
            ret = "float";
            break;
        default:
            ret = "-_-a";
            break;
        }        
        if ( node.isRef() == true){
            ret += "&";
        }
        if ( node.isArray == true){
            ret+= "[]";
        }
        return layoutNullary(ret);
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        if ( node.negative == true){
            ASTIdentifier jjtn000 = new ASTIdentifier(0);
            jjtn000.spelling = "Neg.";
            return layoutBinary("UnaryExp",jjtn000,node.children[0]);
        }
        else{
            return layoutUnary("UnaryExp.",node.children[0]);
        }
    }

    public Object visit(ASTVariableDeclarator node, Object data) {       
        return layoutArray("Var.Decl.",node.children);
    }

    public Object visit(ASTArgumentList node, Object data) {
        return layoutArray("Args.",node.children);
    }

    public Object visit(ASTWhileSt node, Object data) {
        return layoutArray("While",node.children);
    }

    public Object visit(SimpleNode node, Object data) {
        // TODO Auto-generated method stub
        return null;
    }

  private final int BORDER = 5;
  private final int PARENT_SEP = 30;

  private FontMetrics fontMetrics;

  public LayoutVisitor (FontMetrics fontMetrics) {
    this.fontMetrics = fontMetrics;
  }

  private DrawingTree layoutCaption (String name) {
    int w = fontMetrics.stringWidth(name) + 4;
    int h = fontMetrics.getHeight() + 4;
    return new DrawingTree(name, w, h);
  }

  private DrawingTree layoutNullary (String name) {
    DrawingTree dt = layoutCaption(name);
    dt.contour.upper_tail = new Polyline(0, dt.height + 2 * BORDER, null);
    dt.contour.upper_head = dt.contour.upper_tail;
    dt.contour.lower_tail = new Polyline(-dt.width - 2 * BORDER, 0, null);
    dt.contour.lower_head = new Polyline(0, dt.height + 2 * BORDER, dt.contour.lower_tail);
    return dt;
  }

  private DrawingTree layoutUnary (String name, Node child1) {
    DrawingTree dt = layoutCaption(name);
    DrawingTree d1 = (DrawingTree) child1.jjtAccept(this, null);
    dt.setChildren(new DrawingTree[] {d1});
    attachParent(dt, join(dt));
    return dt;
  }

  private DrawingTree layoutBinary (String name, Node child1, Node child2) {
    DrawingTree dt = layoutCaption(name);
    DrawingTree d1 = (DrawingTree) child1.jjtAccept(this, null);
    DrawingTree d2 = (DrawingTree) child2.jjtAccept(this, null);
    dt.setChildren(new DrawingTree[] {d1, d2});
    attachParent(dt, join(dt));
    return dt;
  }

  private DrawingTree layoutTernary (String name, Node child1, Node child2,
                                     Node child3) {
    DrawingTree dt = layoutCaption(name);
    DrawingTree d1 = (DrawingTree) child1.jjtAccept(this, null);
    DrawingTree d2 = (DrawingTree) child2.jjtAccept(this, null);
    DrawingTree d3 = (DrawingTree) child3.jjtAccept(this, null);
    dt.setChildren(new DrawingTree[] {d1, d2, d3});
    attachParent(dt, join(dt));
    return dt;
  }
  
  private DrawingTree layoutArray( String name, Node[] list){
      if (list==null) return layoutNullary(name+":null");
      DrawingTree dt = layoutCaption (name);
      DrawingTree dch[] = new DrawingTree[list.length];
      for (int i=0;i<list.length;i++){
          dch[i] = (DrawingTree) list[i].jjtAccept(this, null);
      }
      dt.setChildren(dch);
      attachParent(dt,join(dt));
      return dt;
  }

  private DrawingTree layoutQuaternary (String name, Node child1, Node child2,
                                        Node child3, Node child4) {
    DrawingTree dt = layoutCaption(name);
    DrawingTree d1 = (DrawingTree) child1.jjtAccept(this, null);
    DrawingTree d2 = (DrawingTree) child2.jjtAccept(this, null);
    DrawingTree d3 = (DrawingTree) child3.jjtAccept(this, null);
    DrawingTree d4 = (DrawingTree) child4.jjtAccept(this, null);
    dt.setChildren(new DrawingTree[] {d1, d2, d3, d4});
    attachParent(dt, join(dt));
    return dt;
  }

  private void attachParent(DrawingTree dt, int w) {
    int y = PARENT_SEP;
    int x2 = (w - dt.width) / 2 - BORDER;
    int x1 = x2 + dt.width + 2 * BORDER - w;

    dt.children[0].offset.y = y + dt.height;
    dt.children[0].offset.x = x1;
    dt.contour.upper_head = new Polyline(0, dt.height,
                                new Polyline(x1, y, dt.contour.upper_head));
    dt.contour.lower_head = new Polyline(0, dt.height,
                                new Polyline(x2, y, dt.contour.lower_head));
  }

  private int join (DrawingTree dt) {
    int w, sum;

    dt.contour = dt.children[0].contour;
    sum = w = dt.children[0].width + 2 * BORDER;

    for (int i = 1; i < dt.children.length; i++) {
      int d = merge(dt.contour, dt.children[i].contour);
      dt.children[i].offset.x = d + w;
      dt.children[i].offset.y = 0;
      w = dt.children[i].width + 2 * BORDER;
      sum += d + w;
    }
    return sum;
  }

  private int merge(Polygon c1, Polygon c2) {
    int x, y, total, d;
    Polyline lower, upper, b;

    x = y = total = 0;
    upper = c1.lower_head;
    lower = c2.upper_head;

    while (lower != null && upper != null) {
        d = offset(x, y, lower.dx, lower.dy, upper.dx, upper.dy);
	x += d;
	total += d;

	if (y + lower.dy <= upper.dy) {
	  x += lower.dx;
	  y += lower.dy;
	  lower = lower.link;
	} else {
	  x -= upper.dx;
	  y -= upper.dy;
	  upper = upper.link;
	}
      }

      if (lower != null) {
        b = bridge(c1.upper_tail, 0, 0, lower, x, y);
        c1.upper_tail = (b.link != null) ? c2.upper_tail : b;
        c1.lower_tail = c2.lower_tail;
      } else {
        b = bridge(c2.lower_tail, x, y, upper, 0, 0);
        if (b.link == null) {
          c1.lower_tail = b;
        }
      }

      c1.lower_head = c2.lower_head;

      return total;
    }

  private int offset (int p1, int p2, int a1, int a2, int b1, int b2) {
    int d, s, t;

    if (b2 <= p2 || p2 + a2 <= 0) {
      return 0;
    }

    t = b2 * a1 - a2 * b1;
    if (t > 0) {
      if (p2 < 0) {
        s = p2 * a1;
        d = s / a2 - p1;
      } else if (p2 > 0) {
        s = p2 * b1;
        d = s / b2 - p1;
      } else {
        d = -p1;
      }
    } else if (b2 < p2 + a2) {
      s = (b2 - p2) * a1;
      d = b1 - (p1 + s / a2);
    } else if (b2 > p2 + a2) {
      s = (a2 + p2) * b1;
      d = s / b2 - (p1 + a1);
    } else {
      d = b1 - (p1 + a1);
    }

    if (d > 0) {
      return d;
    } else {
      return 0;
    }
  }

  private Polyline bridge (Polyline line1, int x1, int y1,
                           Polyline line2, int x2, int y2) {
    int dy, dx, s;
    Polyline r;

    dy = y2 + line2.dy - y1;
    if (line2.dy == 0) {
      dx = line2.dx;
    } else {
      s = dy * line2.dx;
      dx = s / line2.dy;
    }

    r = new Polyline(dx, dy, line2.link);
    line1.link = new Polyline(x2 + line2.dx - dx - x1, 0, r);

    return r;
  }

public Object visit(ASTCallCommand node, Object data) {
    return layoutArray("Call",node.children);
}

}