<!--
Cyworld Synchronizer
다이어리 한 페이지를 item들로 바꾸기
누가: 신재호 <netj@ropas.snu.ac.kr>
언제: 2004-12-02
-->
<xsl:stylesheet
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:exsl="http://exslt.org/common"
    xmlns:cync="http://netj.org/2005/cync"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="html exsl"
    version="1.0">

    <xsl:output method="xml" omit-xml-declaration="yes" encoding="utf-8"
        cdata-section-elements="cync:content"/>

    <xsl:template match="/">
        <items>
            <xsl:apply-templates select="//table[@background='http://img.cyworld.nate.com/img/pwin/dia_body_bg2.gif']/tr/td[1]"/>
	</items>
    </xsl:template>

    <xsl:template match="//table/tr/td">
        <xsl:variable name="id" select="../../preceding-sibling::a/@name"/>
        <xsl:variable name="img" select="table[2]//img"/>

        <xsl:variable name="offset">
            <xsl:choose>
                <xsl:when test="$img">2</xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="title"
            select="table[2]//br[1+$offset]/preceding-sibling::text()"/>

        <xsl:variable name="textbegin">
            <xsl:call-template name="beginning-of-text">
                <xsl:with-param name="m" select="$title"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="text" select="exsl:node-set($textbegin)"/>

        <xsl:variable name="date">
            <xsl:call-template name="to-iso-date">
                <xsl:with-param name="date">
                    <xsl:choose>
                        <xsl:when test="contains(table[1], ')')">
                            <xsl:value-of
                                select="substring-before(table[1], '(')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="table[1]"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:variable>

        <item cync:id="diary_{$id}">
            <title>
                <xsl:choose>
                    <xsl:when test="$title">
                        <xsl:value-of select="$title"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="table[2]"/>
                    </xsl:otherwise>
                </xsl:choose>
            </title>
            <description>
                <xsl:if test="$img">
                    &lt;img src="<xsl:value-of select="$img/@src"/>"
                    width="175" align="left"&gt;
                </xsl:if>
                <xsl:apply-templates select="$text"
                    mode="rss-description"/></description>
            <dc:date><xsl:value-of select="$date"/></dc:date>
            <xsl:if test="$img"><cync:image src="{$img/@src}"/></xsl:if>
            <cync:content><xsl:apply-templates select="$text"
                    mode="cync-content"/></cync:content>
            <cync:timestamp>
                <xsl:choose>
                    <xsl:when test="contains($date, 'T')">
                        <xsl:value-of select="$date"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="to-iso-date">
                            <xsl:with-param name="date">
                                <xsl:choose>
                                    <xsl:when test="contains(table[1], ')')">
                                        <xsl:value-of select="substring-after(
                                            substring-before(table[1], ')'), '(')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="table[1]"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </cync:timestamp>
        </item>
        <!-- comments -->
        <xsl:for-each select="table[4]/form/tr/td/a">
            <item cync:id="diary_{$id}_{position()}">
                <cync:author><xsl:value-of select="."/></cync:author>
                <title><xsl:value-of select="$title"/> <xsl:value-of
                        select="."/>의 <xsl:value-of select="position()"/>번 덧글</title>
                <description><xsl:value-of select="normalize-space(
                        substring-after(following-sibling::text(), ':'))"/></description>
                <dc:date><xsl:call-template name="to-iso-date">
                        <xsl:with-param name="date" select="translate(
                            following-sibling::font[1], '()', ' ')"/>
                </xsl:call-template></dc:date>
            </item>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="beginning-of-text">
        <xsl:param name="m"/>
        <xsl:choose>
            <xsl:when test="$m/following-sibling::br[1] = $m/following-sibling::node()[1]">
                <xsl:call-template name="beginning-of-text">
                    <xsl:with-param name="m" select="$m/following-sibling::br[1]"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="$m/following-sibling::node()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="to-iso-date">
        <xsl:param name="date"/>
        <xsl:value-of select="translate(
            normalize-space($date), ' .', 'T-')"/>
        <xsl:text>+09:00</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="rss-description">
        <xsl:apply-templates mode="rss-description"/>
    </xsl:template>

    <xsl:template match="br" mode="rss-description">
        <xsl:text>&lt;br&gt;</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="cync-content">
        <xsl:apply-templates mode="cync-content"/>
    </xsl:template>

    <xsl:template match="br" mode="cync-content">
        <xsl:text>&#10;</xsl:text>
    </xsl:template>

</xsl:stylesheet>
