#!/usr/bin/env bash
# Cync -- Cyworld Synchronizer
# Author: Jaeho Shin <netj@ropas.snu.ac.kr>
# Created: 2004-12-02
Version=1.20050915

Depth=${CYNC_DEPTH:-5}

prep_cookies() {
    if ! [ -f "$tmp/cookies.txt" ]; then
        cat >"$tmp/cookies.txt" <<EOF
.nate.com	TRUE	/	FALSE	2000000000	pcid	cync_`hostname`
EOF
    fi
}

clean_page() {
    iconv -f cp949 -t utf-8 \
    |sed -e 's#
$##g' \
    |sed -e 's#&#\&amp;#g' \
    |sed -e 's#&amp;nbsp;\?# #g' \
    |sed -e 's#ks_c_5601-1987#utf-8#g' \
    |sed -e 's# <br> #<br>#g' \
    |sed -e 's#[ \t]*</td>#</td>#g' \
    |perl -e '
    $a=join "", <>;
    $a =~ s:<script[^>]*>.*?</script>::gs;
    $a =~ s:<!--.*?-->::gs;
    print $a' \
    |xmllint --recover --html --xmlout --encode utf-8 - 2>/dev/null
}

convert_page() {
    xsltproc --novalid "$BaseDir/diary-page2items.xsl" -
}

merge_items() {
    xsltproc --novalid \
        --param owner "'$1'" \
        --param url "'$2'" \
        --param version "'$Version'" \
        "$BaseDir/diary-items2rss.xsl" -
}

format_xml() {
    xmllint --format --encode utf-8 -
}


get() {
    (
    prep_cookies
    wget --quiet --user-agent="Cync/$Version" \
        --cookies=on --load-cookies="$tmp/cookies.txt" \
        "$@"
    )
}


BaseDir=$(cd "`dirname "$0"`"; pwd)

set -e
if [ -n "$CYNC_DEBUG" ]; then
    tmp=$CYNC_DEBUG
else
    tmp=`mktemp -d /tmp/cync.XXXXXX`
    tee() { cat; }
    trap "rm -rf $tmp; exit" EXIT SIGINT SIGHUP SIGTERM
fi

case "$1" in
    get)
    "$@"
    ;;

    diary.rss) shift
    id=$1
    tid=`get -O- "http://cyworld.nate.com/$id" | grep '?tid=' | \
        sed -e 's/.*\?tid=\([0-9]\+\).*/\1/'`

    cd "$tmp"
    get --follow-tags='a' --recursive --level=$Depth \
        --relative --no-parent --no-directories --timestamping --random-wait \
        "http://minihp.cyworld.nate.com/pims/diary5/mydiary/diary5_mydiary_itemview.asp?tid=$tid"

    {
        set +e
        echo "<items-set>"
        for i in `find "$tmp" -name 'diary*.asp*' ! -name '*.cync'`; do
            clean_page <"$i" | tee "$i.cync" | convert_page
        done
        echo "</items-set>"
    } \
    |merge_items "$id" \
        "http://minihp.cyworld.nate.com/pims/main/pims_main.asp?tid=$tid" \
    |format_xml
    cd -
    ;;

    *)
    cat <<USAGE
Cync -- Cyworld Synchronizer $Version
: cync diary.rss <Ȩ ּ ̸>
        cync get [wget option] <URL> ...

,
    cync diary.rss netj
    cync get http://img.cyworld.nate.com/common/file_down.asp?redirect=%2Fc7601%2F2004%2F10%2F2%2F98%2Fcy%2EJPG

USAGE
    exit 2
    ;;
esac
