<!--
Cyworld Synchronizer
item들 뽑아서 rss 만들기
누가: 신재호 <netj@ropas.snu.ac.kr>
언제: 2004-12-02
-->
<xsl:stylesheet
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:set="http://exslt.org/sets"
    xmlns:cync="http://netj.org/2005/cync"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="html set"
    version="1.0">
    <xsl:output method="xml" encoding="utf-8"
        cdata-section-elements="cync:content"/>
    <xsl:param name="owner"/>
    <xsl:param name="url"/>
    <xsl:param name="version" select="'1.0'"/>

    <xsl:template match="/">
	<rss version="2.0">
	    <channel>
		<title><xsl:value-of select="$owner"/>의 싸이 다이어리</title>
		<link><xsl:value-of select="$url"/></link>
		<language>ko</language>
		<description/>
                <xsl:for-each select="set:distinct(//item)">
                    <xsl:sort select="dc:date" order="descending"/>
                    <xsl:copy-of select="."/>
                </xsl:for-each>
	    </channel>
	</rss>
        <xsl:comment>Generated by Cync/<xsl:value-of
                select="$version"/></xsl:comment>
    </xsl:template>

</xsl:stylesheet>
