/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.narusas.daap.server.DaapRequest;

public class DaapRequestTest
extends TestCase {
    static final String CRLF = "\r\n";

    public void testParsingServerInfo() throws Exception {
        String src = "GET /server-info HTTP/1.1\r\nHost: 192.168.1.100:3699\r\nAccept: */*\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nClient-DAAP-Version: 2.0\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"MSRV", (String)req.getResponse());
    }

    public void testParsingContentCodes() throws Exception {
        String src = "GET /content-codes HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"MCCR", (String)req.getResponse());
    }

    public void testLogin() throws Exception {
        String src = "GET /login HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"MLOG", (String)req.getResponse());
    }

    public void testUpdate() throws Exception {
        String src = "GET /update?session-id=1517514686&revision-number=1 HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Validation: E6E20DE3EA343C37CF99A2AB9233069E\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"MUPD", (String)req.getResponse());
        Assert.assertEquals((String)"1517514686", (String)req.getSessionId());
        Assert.assertEquals((int)1, (int)req.getRevision());
    }

    public void testDatabase() throws Exception {
        String src = "GET /databases?session-id=1517514686&revision-number=10 HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Validation: 94B9251C51D34E6D177B0BB8324CF7C8\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"AVDB", (String)req.getResponse());
        Assert.assertEquals((String)"1517514686", (String)req.getSessionId());
        Assert.assertEquals((int)10, (int)req.getRevision());
    }

    public void testDatabases() throws Exception {
        String src = "GET /databases/32/items?type=music&meta=dmap.itemid,dmap.itemname,dmap.itemkind,dmap.persistentid,daap.songalbum,daap.songgrouping,daap.songartist,daap.songbitrate,daap.songbeatsperminute,daap.songcomment,daap.songcompilation,daap.songcomposer,daap.songdateadded,daap.songdatemodified,daap.songdisccount,daap.songdiscnumber,daap.songdisabled,daap.songeqpreset,daap.songformat,daap.songgenre,daap.songdescription,daap.songrelativevolume,daap.songsamplerate,daap.songsize,daap.songstarttime,daap.songstoptime,daap.songtime,daap.songtrackcount,daap.songtracknumber,daap.songuserrating,daap.songyear,daap.songdatakind,daap.songdataurl,com.apple.itunes.norm-volume&session-id=1517514686&revision-number=10 HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Validation: 574AC394232266DFDCB9A6F9F347851B\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"ADBS", (String)req.getResponse());
        Assert.assertEquals((String)"1517514686", (String)req.getSessionId());
        Assert.assertEquals((int)10, (int)req.getRevision());
        Assert.assertEquals((String)"32", (String)req.getDatabase());
        Assert.assertTrue((boolean)req.containMeta("dmap.itemid"));
        Assert.assertTrue((boolean)req.containMeta("dmap.itemname"));
        Assert.assertTrue((boolean)req.containMeta("dmap.itemkind"));
        Assert.assertTrue((boolean)req.containMeta("com.apple.itunes.norm-volume"));
        Assert.assertFalse((boolean)req.containMeta("ddd.ddd"));
    }

    public void testContainers() throws Exception {
        String src = "GET /databases/32/containers?meta=dmap.itemid,dmap.itemname,dmap.persistentid,com.apple.itunes.smart-playlist&session-id=1517514686&revision-number=10 HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Validation: 39530328BDE52F77692355F80AE64A69\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"APLY", (String)req.getResponse());
        Assert.assertEquals((String)"1517514686", (String)req.getSessionId());
        Assert.assertEquals((int)10, (int)req.getRevision());
        Assert.assertEquals((String)"32", (String)req.getDatabase());
        Assert.assertTrue((boolean)req.containMeta("dmap.itemid"));
        Assert.assertTrue((boolean)req.containMeta("com.apple.itunes.smart-playlist"));
        Assert.assertFalse((boolean)req.containMeta("ddd.ddd"));
    }

    public void testContainer() throws Exception {
        String src = "GET /databases/32/containers/36/items?type=music&meta=dmap.itemkind,dmap.itemid,dmap.containeritemid&session-id=1517514686&revision-number=10 HTTP/1.1\r\nHost: 192.168.1.100\r\nClient-DAAP-Version: 2.0\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nAccept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25\r\nClient-DAAP-Validation: AD2EA6ED8B2C9A940EF29AA62BC12B0C\r\nClient-DAAP-Access-Index: 1\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"APSO", (String)req.getResponse());
        Assert.assertEquals((String)"1517514686", (String)req.getSessionId());
        Assert.assertEquals((int)10, (int)req.getRevision());
        Assert.assertEquals((String)"32", (String)req.getDatabase());
        Assert.assertEquals((String)"36", (String)req.getPlaylist());
        Assert.assertTrue((boolean)req.containMeta("dmap.itemid"));
        Assert.assertTrue((boolean)req.containMeta("dmap.containeritemid"));
        Assert.assertFalse((boolean)req.containMeta("ddd.ddd"));
    }

    public void testMP3() throws Exception {
        String src = "GET /databases/31/items/21.mp3?session-id=462121433 HTTP/1.1\r\nHost: 192.168.1.100:3699\r\nCache-Control: no-cache\r\nAccept: */*\r\nx-audiocast-udpport:1230\r\nicy-metadata:1\r\nUser-Agent: iTunes/4.2 (Windows; N)\r\nConnection: close\r\nClient-DAAP-Access-Index: 1\r\nClient-DAAP-Validation: 082AC24D0100A60352256DAD7B571575\r\n\r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        Assert.assertEquals((String)"MP3D", (String)req.getResponse());
        Assert.assertEquals((String)"462121433", (String)req.getSessionId());
        Assert.assertEquals((String)"31", (String)req.getDatabase());
        Assert.assertEquals((String)"21.mp3", (String)req.getMP3());
    }
}

