/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import net.narusas.daap.server.DaapSession;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.UpdateListener;
import net.narusas.daap.server.dummy.DummyDatabase;

public class JDaapServer
extends Thread
implements UpdateListener {
    private int listenPort;
    static final int DEFAULT_DAAP_PORT = 3699;
    private ServerSocket serverSocket;
    private Database _db;
    private JmDNS _jmdns;
    private List _sessions;

    public JDaapServer(Database db) {
        this._db = db;
        this.listenPort = 3699;
        this._sessions = new ArrayList();
    }

    public void run() {
        this.setName("JDaapServer");
        this.createServerSocket();
        this.adverstiseZeroconf();
        while (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                Socket connection = this.serverSocket.accept();
                connection.setTcpNoDelay(true);
                DaapSession session = new DaapSession(this, connection, this._db);
                this._sessions.add(session);
                session.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void adverstiseZeroconf() {
        try {
            this._jmdns = new JmDNS();
            this._jmdns.registerService(new ServiceInfo("_daap._tcp.local.", "Narusas._daap._tcp.local.", this.listenPort, "Text"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createServerSocket() {
        while (true) {
            try {
                this.serverSocket = new ServerSocket(this.listenPort, 5);
                return;
            }
            catch (Exception e) {
                ++this.listenPort;
                continue;
            }
            break;
        }
    }

    public void fireChange() {
    }

    public static void main(String[] args) {
        JDaapServer server = new JDaapServer(new DummyDatabase());
        server.start();
    }

    public void updated(Database evetSource) {
        this.updateSessions(evetSource);
    }

    private void updateSessions(Database evetSource) {
        Iterator it = this._sessions.iterator();
        while (it.hasNext()) {
            UpdateListener listener = (UpdateListener)it.next();
            listener.updated(evetSource);
        }
    }

    public void removeSession(DaapSession session) {
        this._sessions.remove(session);
    }
}

