/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.Song;
import net.narusas.daap.server.tag.ListTag;

public class MP3Response
implements DaapResponse {
    private int _uid;
    private Database _db;
    private MP3DownTag _tag;

    public MP3Response(DaapRequest req, Database db) {
        this._uid = Integer.parseInt(req.getMP3());
        this._db = db;
        this._tag = new MP3DownTag(db.getPlaylists()[0].getSong(this._uid));
    }

    public ListTag getResponse() {
        return this._tag;
    }

    class MP3DownTag
    extends ListTag {
        private Song _song;

        public MP3DownTag(Song song) {
            super("MP3D");
            this._song = song;
        }

        public String getName() {
            return "MP3D";
        }

        public void toDaap(OutputStream out) {
            try {
                int r;
                InputStream in = this._song.getMusicStream();
                byte[] buf = new byte[1024];
                while ((r = in.read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, r);
                }
                out.flush();
                in.close();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public boolean isStreaming() {
            return true;
        }
    }
}

