/*
 * Created on 2004. 2. 18.
 *
 */
package net.narusas.daap.server;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jmdns.*;

import net.narusas.daap.server.api.*;
import net.narusas.daap.server.dummy.DummyDatabase;


/**
 * @author Jisung, Ahn
 *
 */
public class JDaapServer extends Thread implements UpdateListener {
    /**
     * Port we listen on
     */
    private int listenPort;

    final static int DEFAULT_DAAP_PORT = 3699;
    private ServerSocket serverSocket;
    private Database _db;
    private JmDNS _jmdns;
    private List _sessions;


    public JDaapServer(Database db) {
        _db = db;
        listenPort = DEFAULT_DAAP_PORT;
        _sessions = new ArrayList();
        
    }
    

    public void run() {
        this.setName("JDaapServer");
        createServerSocket();
        adverstiseZeroconf();

        while (serverSocket != null && !serverSocket.isClosed()) {

            // Accept a socket.
            try {
                Socket connection = serverSocket.accept();
                connection.setTcpNoDelay(true);

                // Pass it to the request handler
                DaapSession session = new DaapSession(this, connection, _db);
                _sessions.add(session);
                session.start();
            }
            catch (IOException e) {
                // comms error.
            }

            // Sleep for a bit.
            try {
                Thread.sleep(100);
            }
            catch (InterruptedException e) {}

        }
    }

    /**
     * adverstiseZeroconf
     */
    private void adverstiseZeroconf() {
        try {
            _jmdns = new JmDNS();
            _jmdns.registerService(new ServiceInfo("_daap._tcp.local.","Narusas._daap._tcp.local.",listenPort,"Text"));
//            _jmdns.addServiceListener("*",new ServiceListener(){
//                public void addService(javax.jmdns.JmDNS jmdns, java.lang.String type, java.lang.String name) {
//                    System.out.println("## Add : T:"+type+" N:"+name);
//                }
//                public void removeService(javax.jmdns.JmDNS jmdns, java.lang.String type, java.lang.String name) {
//                }
//                public void resolveService(javax.jmdns.JmDNS jmdns, java.lang.String type, java.lang.String name, javax.jmdns.ServiceInfo info){
//                    System.out.println("## remove : T:"+type+" N:"+name);
//                }
//            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createServerSocket() {
        while(true) {
            try {
                serverSocket = new ServerSocket(listenPort, 5);
                return;
            }
            catch (Exception e) {
                listenPort++;
            }
        }
    }

    public void fireChange() {

    }

    public static void main(String[] args) {
        JDaapServer server = new JDaapServer(new DummyDatabase());
        server.start();
    }


	/* (non-Javadoc)
	 * @see net.narusas.daap.server.api.UpdateListener#updated(net.narusas.daap.server.api.Database)
	 */
	public void updated(Database evetSource) {
		updateSessions(evetSource);		
	}


	/**
	 * 
	 */
	private void updateSessions(Database evetSource) {
		Iterator it = _sessions.iterator();
		while(it.hasNext()){
			UpdateListener listener = (UpdateListener) it.next();
			listener.updated(evetSource);
		}
		
	}


	/**
	 * @param session
	 */
	public void removeSession(DaapSession session) {
		_sessions.remove(session);		
	}

}
