/*
 * Created on 2004. 2. 20.
 */

package net.narusas.daap.server.response;

import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.Song;
import net.narusas.daap.server.tag.*;

/**
 * @author Jisung, Ahn
 */
public class SongsResponse implements DaapResponse {

	ListTag apso;

	public SongsResponse(DaapRequest req, Database _db) {
		int pliayListUid = Integer.parseInt(req.getPlaylist());
		Song[] songs = _db.getPlaylists()[pliayListUid-1].getAllSongs();
		apso = Tag.listTag("apso");
		apso.addTag(Tag.integerTag("mstt", 200));
		apso.addTag(Tag.byteTag("muty", 0));
		apso.addTag(Tag.integerTag("mtco", songs.length));
		apso.addTag(Tag.integerTag("mrco", songs.length));
		ListTag mdcl = Tag.listTag("mlcl");
		apso.addTag(mdcl);
		for (int i = 0; i < songs.length; i++) {
			Song song = songs[i];
			long current = System.currentTimeMillis();
			ListTag mlit = Tag.listTag("mlit");
			mdcl.addTag(mlit);
			mlit.addTag(Tag.byteTag("mikd", 2));
			mlit.addTag(Tag.integerTag("miid", song.getUID()));
			mlit.addTag(Tag.integerTag("mcti", song.getUID()));
		}
	}
	public ListTag getResponse() {
		return apso;
	}
}
