/*
 * Created on 2004. 2. 18. To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

package net.narusas.daap.server.tag;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * @author Jisung, Ahn To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Generation - Code and
 *         Comments
 */
public abstract class Tag {

	public static final int TYPE_SIGNED_BYTE = 1;
	public static final int TYPE_UNSIGNED_BYTE = 2;
	public static final int TYPE_SIGNED_SHORT = 3;
	public static final int TYPE_UNSIGNED_SHORT = 4;
	public static final int TYPE_SIGNED_INT = 5;
	public static final int TYPE_UNSIGNED_INT = 6;
	public static final int TYPE_SIGNED_LONG = 7;
	public static final int TYPE_UNSIGNED_LONG = 8;
	public static final int TYPE_STRING = 9;
	public static final int TYPE_DATE = 10;
	public static final int TYPE_VERSION = 11;
	public static final int TYPE_LIST = 12;
	protected int _type;
	protected String _name;

	public static ByteTag byteTag(String name, int data) {
		ByteTag tag = new ByteTag(name);
		tag.setData(data);
		return tag;
	}
	public static ShortTag shortTag(String name, int data) {
		ShortTag tag = new ShortTag(name);
		tag.setData(data);
		return tag;
	}
	public static IntegerTag integerTag(String name, int data) {
		IntegerTag tag = new IntegerTag(name);
		tag.setData(data);
		return tag;
	}
	public static LongTag longTag(String name, long data) {
		LongTag tag = new LongTag(name);
		tag.setData(data);
		return tag;
	}
	public static DateTag dateTag(String name, long data) {
		DateTag tag = new DateTag(name);
		tag.setData(data);
		return tag;
	}
	public static VersionTag versionTag(String name, int major, int minor, int micro) {
		VersionTag tag = new VersionTag(name);
		tag.setData(major, minor, micro);
		return tag;
	}
	public static StringTag stringTag(String name, String data) {
		StringTag tag = new StringTag(name);
		tag.setData(data);
		return tag;
	}
	public static ListTag listTag(String name) {
		return new ListTag(name);
	}
	/**
	 * Tag  Data ȯѴ.
	 * 
	 * @return
	 */
	public abstract byte[] getData();
	public abstract int getDataLength();
	public int length() {
		return 8 + getDataLength();
	}
	public String getName() {
		return _name;
	}
	public int getType() {
		return _type;
	}
	public byte[] toDaap() {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		try {
			bout.write(getName().getBytes());
			bout.write(intTo4Bytes(getDataLength()));
			bout.write(getData());
			return bout.toByteArray();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	public void toDaap(OutputStream out) {
		try {
			out.write(toDaap());
			out.flush();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}
	public static int byteToInt(byte[] data) {
		int b3 = (data[0] & 0xff) << 24;
		int b2 = (data[1] & 0xff) << 16;
		int b1 = (data[2] & 0xff) << 8;
		int b0 = data[3] & 0xff;
		return b3 | b2 | b1 | b0;
	}
	public static long byteToLong(byte[] data) {
		long b7 = (data[0] & 0xff) << 56;
		long b6 = (data[1] & 0xff) << 48;
		long b5 = (data[2] & 0xff) << 40;
		long b4 = (data[3] & 0xff) << 32;
		long b3 = (data[4] & 0xff) << 24;
		long b2 = (data[5] & 0xff) << 16;
		long b1 = (data[6] & 0xff) << 8;
		long b0 = data[7] & 0xff;
		return b7 | b6 | b5 | b4 | b3 | b2 | b1 | b0;
	}
	public static int byteToSort(byte[] data) {
		int b1 = (data[0] & 0xff) << 8;
		int b0 = data[1] & 0xff;
		return b1 | b0;
	}
	public static byte[] intTo4Bytes(int i) {
		byte[] b = new byte[4];
		b[3] = (byte) (i & 0xFF);
		b[2] = (byte) ((i >>> 8) & 0xFF);
		b[1] = (byte) ((i >>> 16) & 0xFF);
		b[0] = (byte) ((i >>> 24) & 0xFF);
		return b;
	}
}
