/*
 * Created on 2004. 2. 29.
 *
 * All rights is reserved to Jisung, Ahn
 */
package net.narusas.daap.server.util;

import java.util.Arrays;


/**
 * 
 * @author Jisung, Ahn
 *
 */
public class Authenticator {
	static int staticHashDone = 0;
	static byte[] staticHash = new byte[256*65];

	static final byte[] hexchars = "0123456789ABCDEF".getBytes();
	static final byte[] appleCopyright = "Copyright 2003 Apple Computer, Inc.".getBytes();
	
	
	public String generateHash(String url, char hashSelect){
		byte[] temp = new byte[256*65];
		Arrays.fill(temp, (byte) 0);
		temp = MD5.digest(temp, url.getBytes());
		return MD5.toHex(temp);
	}
	
	private byte[] getPreparedHash() {
		byte[] temp = new byte[256*65];
		Arrays.fill(temp, (byte) 0);
		for(int i=0; i < 256; i++) {
			if ((i & 0x80) != 0) {
				temp = MD5.digest(temp, "Accept-Language".getBytes());
			}
			else {
				temp = MD5.digest(temp, "user-agent".getBytes());
			}
			
			if ((i & 0x40) != 0) {
				temp = MD5.digest(temp, "max-age".getBytes());
			}
			else {
				temp = MD5.digest(temp, "Authorization".getBytes());
			}
			
			if ((i & 0x20) != 0) {
				temp = MD5.digest(temp, "Client-DAAP-Version".getBytes());
			}
			else {
				temp = MD5.digest(temp, "Accept-Encoding".getBytes());
			}
			
			if ((i & 0x10) != 0) {
				temp = MD5.digest(temp, "daap.protocolversion".getBytes());
			}
			else {
				temp = MD5.digest(temp, "daap.songartist".getBytes());
			}
			
			if ((i & 0x08) != 0) {
				temp = MD5.digest(temp, "daap.songcomposer".getBytes());
			}
			else {
				temp = MD5.digest(temp, "daap.songdatemodified".getBytes());
			}
			
			if ((i & 0x04) != 0) {
				temp = MD5.digest(temp, "daap.songdiscnumber".getBytes());
			}
			else {
				temp = MD5.digest(temp, "daap.songdisabled".getBytes());
			}
			
			if ((i & 0x02) != 0) {
				temp = MD5.digest(temp, "playlist-item-spec".getBytes());
			}
			else {
				temp = MD5.digest(temp, "revision-number".getBytes());
			}
			
			if ((i & 0x01) != 0){
				temp = MD5.digest(temp, "session-id".getBytes());
			}
			else {
				temp = MD5.digest(temp, "content-codes".getBytes());
			}
			
		}
		return temp;
	}
	
}
