#!/usr/bin/python
# -*- coding: UTF-8 -*-

from time import localtime , strftime , strptime
from cStringIO import StringIO

TAB = "    "
NEW = "\n"
def StartEnd(itemname,data,strip=None,typec=False):
	if type(data) != type(''):
		data = reduce( lambda x , y : x + y , data)
	if strip:
		data = strip(data)
	if typec is False:
		data = data.replace('&nbsp;',' ')
		data = data.replace('</p>','')
		data = data.replace('&#49165;','ޤ')
		data = data.replace('</br>','')
		data = data.replace('<br>','\n')
		data = data.replace('&','&amp;')
	else:
		data = "<![CDATA[" + data + "]]>"
	try:
		data = 	data.decode('cp949').encode('utf-8')
	except:
		pass
	return '<%s>%s</%s>' % ( itemname , data , itemname )

def GetCurKst():
	return strftime("%a, %d %b %Y %H:%M:%S KST", localtime())

def GetCurKstFromZB(data):
	# Sun, 18 Jul 2004 00:07:03 KST
	# 2004 07 16 10 25 15
	date = strptime(data,"%Y %m %d %H %M %S")
	return strftime("%a, %d %b %Y %H:%M:%S KST",date)

	
def RssMaker(ArticleData,CFG,FileName="zbrss.rss",strip=str.strip):
	rss = []
	rss.append('<?xml version="1.0"?>' + NEW )
	rss.append('<rss version="2.0">'  + NEW )
	rss.append( TAB * 1 + "<channel>"  + NEW)
	for keys in CFG["CHANNEL"].keys():
		rss.append( TAB * 2 + StartEnd(keys,CFG["CHANNEL"][keys]) + NEW )
	rss.append( TAB * 2 + StartEnd("pubDate",GetCurKst()) + NEW )			
	rss.append( TAB * 2 + StartEnd("lastBuildDate",GetCurKst()) + NEW )			
	for Article in ArticleData:
		rss.append( TAB * 2 + "<item>" + NEW)
		rss.append( TAB * 3 + StartEnd("title", Article["TOPIC"] ) + NEW )
		rss.append( TAB * 3 + StartEnd("link", Article["URL"] ) + NEW )
		#rss.append( TAB * 3 + StartEnd("description"," ") + NEW)
		rss.append( TAB * 3 + StartEnd("description",  Article["CONTENTS"] ,strip,typec=True ) + NEW )
		#rss.append( TAB * 3 + StartEnd("content:encoded",  Article["CONTENTS"] ,strip ) )
		rss.append( TAB * 3 + StartEnd("pubDate", GetCurKstFromZB(Article["TIME"]) ) + NEW )
		rss.append( TAB * 3 + StartEnd("guide", Article["URL"] ) + NEW )
		rss.append( TAB * 3 + StartEnd("author", Article["AUTHOR"] ) + NEW )
		rss.append( TAB * 2 + "</item>" + NEW)
	rss.append( TAB * 1 + "</channel>" + NEW )
	rss.append( "</rss>")
	ret = StringIO()
	ret.writelines(rss)
	ret.seek(0)
	return ret
