<?php
/* $Id$ */

function do_devhelp($formatter,$options)
{
	if($options['mode'] == 'book')
		devhelp_book($formatter,$options);
	else if($options['mode'] == 'library')
		devhelp_library($formatter,$options);
	else if($options['mode'] == 'show')
		devhelp_show($formatter,$options);
	else if($options['mode'] == 'cache')
		devhelp_cache($formatter,$options);
	else {
		$formatter->send_header("Status: 406 Not Acceptable",$options);
		$formatter->send_title("406 Not acceptable","",$options);
		$formatter->send_page("== ".sprintf("%s is not valid mode",$options['mode'])." ==\n");
		$formatter->send_footer("",$options);
	}
}

function devhelp_library($formatter,$options)
{
	global $DBInfo;

	$base_uri = devhelp_get_base_uri();

	$content = $formatter->page->get_raw_body();

	/* create a xmltree of library */
	$doc = domxml_new_doc("1.0");
	$root = $doc->create_element("library");
	$root = $doc->append_child($root);
	$root->set_attribute("name",$DBInfo->sitename);
	$root->set_attribute("uri",$base_uri);
	$root->set_attribute("mtime",$formatter->page->mtime());
	$node_depth[0] = $root;

	$lines = explode("\n",$content);

	foreach($lines as $line){
		$line = preg_replace("/\n$/","",$line);
		
		if(preg_match("/(?<!=)(={1,5})\s(#?)(.*)\s+\\1\s?$/",$line,$match))
		{
			$dep = strlen($match[1]);

			$head = str_replace("<","&lt;",$match[3]);
			/* strip some basic wikitags */
			$head = preg_replace($formatter->baserule,"\\1",$head);
			$head = preg_replace("/\[(.*)\]/","\\1",$head);

			$new_node = $doc->create_element("category");
			$new_node->set_attribute("name",$head);
		
			$node_depth[$dep] = $node_depth[$dep-1]->append_child($new_node);
		}else if(preg_match("/(\* \[([^\]]*)\])/",$line,$match)){
			$new_node = $doc->create_element("book");
			$new_node->set_attribute("title",$match[2]);
			$new_node->set_attribute("cacheable","true");

			$node_depth[$dep]->append_child($new_node);
		}

	}
	
	header("Content-Type: text/xml");
	echo $doc->dump_mem(TRUE);

}

function devhelp_get_base_uri()
{
	preg_match("/(.*\/)/",$_SERVER['REQUEST_URI'],$match);

	return "http://".$_SERVER['SERVER_NAME'].$match[1];
}
		
function devhelp_get_prefix_uri($formatter,$options)
{
	if($_GET['cache'] == 'true')
		$prefix= "";
	else {
		$prefix = "http://".$_SERVER['SERVER_NAME'];
	}

	return $prefix;
}

function devhelp_get_book_name($formatter,$options)
{
	if($_GET['cache'] == 'true')
		return $formatter->page->urlname.".htm";
	else return $formatter->link_url($formatter->page->urlname);
}

function devhelp_book($formatter,$options)
{
	global $DBInfo;

	$book_uri = devhelp_get_prefix_uri($formatter,$options).
				devhelp_get_book_name($formatter,$options);
	$content = $formatter->page->get_raw_body();
		
	/* create a xml tree of book */
	$doc = domxml_new_doc("1.0");
	$root = $doc->create_element("book");
	$root = $doc->append_child($root);
	$root->set_attribute("name",$formatter->page->name);
	$root->set_attribute("version",$formatter->page->get_rev());
	$root->set_attribute("title",$formatter->page->name);
	$root->set_attribute("link",$book_uri);
	$chapters = $doc->create_element("chapters");
	$chapters = $root->append_child($chapters);
	$node_depth[0] = $chapters;

	$functions = $doc->create_element("functions");
	$functions = $root->append_child($functions);

	for($i=1;$i<=5;$i++)
		$toc[$i] = 0;

	$lines = explode("\n",$content);
	$esc_flag = 0;

	foreach($lines as $line){
		$line = preg_replace("/\n$/","",$line);
		
		if(preg_match("/^{{{/",$line,$match))
			$esc_flag=1;

		if($esc_flag == 1 && preg_match("/^}}}/",$line,$match))
			$esc_flag=0;

		if($esc_flag)
			continue;
				
		if(preg_match("/(?<!=)(={1,5})\s(#?)(.*)\s+\\1\s?$/",$line,$match))
		{

			$dep = strlen($match[1]);

			$head = str_replace("<","&lt;",$match[3]);
			/* strip some basic wikitags */
			$head = preg_replace($formatter->baserule,"\\1",$head);
			$head = preg_replace("/\[(.*)\]/","\\1",$head);

			$toc[$dep] += 1;
			devhelp_toc_clear(&$toc,$dep);

			$new_node = $doc->create_element("sub");
			$new_node->set_attribute("name",$head);
			$link = devhelp_link_url($book_uri,$toc,$dep);
			$new_node->set_attribute("link",$link);

			$node_depth[$dep] = $node_depth[$dep-1]->append_child($new_node);
		}

		if(preg_match("/'{2,3}([^']*)'{2,3}/",$line,$match))
		{
			$function = $doc->create_element("function");
			$function->set_attribute("name",$match[1]);
			$function->set_attribute("link",$link);
			$function = $functions->append_child($function);
		}
				
	}

	header("Content-Type: text/xml");
	echo $doc->dump_mem(TRUE);
}

function devhelp_toc_clear(&$toc,$dep)
{
	for($i=$dep+1;$i <= 5;$i++)
		$toc[$i] = 0;
}	

function devhelp_link_url($book_uri,$toc,$dep)
{
	for($i = 1; $i <= $dep;$i ++)
	{
		if($i == 1)
			$anchor = $toc[$i];
		else
			$anchor = $anchor.".".$toc[$i];
	}

	return "$book_uri#s-".$anchor;
}

function devhelp_show ($formatter, $options) {
	global $DBInfo;

	$options['css_url']=$DBInfo->url_prefix."/css/devhelp.css";
	$formatter->send_header("",$options);
	print "<div id='Logo'>";
	print "<img src='".$DBInfo->url_prefix."/imgs/devhelp_logo.png' alt='DevHelpOnNet Logo'/>";
	print "</div>";
	print "<div id='WikiTitle'>";
	print "<h1>$options[page]</h1>";
	print "</div>";
	print "<div id='wikiContent'>";
	$formatter->external_on=1;
	$formatter->send_page();
	print "</div>";
    print "<div class='printFooter'>";
	print "</div>";
	print "</body></html>";
	return;
}

function devhelp_cache ($formatter, $options) {
	global $DBInfo;

	$BASE_URI="http://".$_SERVER['SERVER_NAME'].$DBInfo->url_prefix;

	$options['css_url']=$BASE_URI."/css/devhelp.css";
	$formatter->send_header("",$options);
	print "<div id='Logo'>";
	print "<img src='".$BASE_URI."/imgs/devhelp_logo.png' alt='DevHelpOnNet Logo'/>";
	print "</div>";
	print "<div id='WikiTitle'>";
	print "<h1>$options[page]</h1>";
	print "</div>";
	print "<div id='wikiContent'>";
	$formatter->external_on=1;
	$formatter->send_page();
	print "</div>";
    print "<div class='printFooter'>";
	print "</div>";
	print "</body></html>";
	return;
}

?>
