<?php
/*
  This is the starting file for PhpWiki. All this file does
   is set configuration options, and at the end of the file 
   it includes() the file lib/main.php, where the real action begins.

   This file is divided into six parts: Parts Zero, One, Two, Three,
   Four and Five. Each one has different configuration settings you 
   can change; in all cases the default should work on your system, 
   however, we recommend you tailor things to your particular setting.
*/

/////////////////////////////////////////////////////////////////////
// Part Zero: dbwiki ϵ  ġ Դϴ. 
// DbWiki     ã ϴ     ָ ˴ϴ.
//
//ini_set('include_path', './');

// WikiToDocBook  Դϴ. Ư    ״
// θ ˴ϴ.
define('WikiToDocbookPath', 'lib/wiki2docbook');

/////////////////////////////////////////////////////////////////////
// Part Null: Don't touch this!

define ('PHPWIKI_VERSION', '1.3.0-jeffs-hacks');
require "lib/prepend.php";
rcs_id('$Id: index.php,v 1.20 2005/04/24 08:57:29 gryu Exp $');

/////////////////////////////////////////////////////////////////////
//
// Part One:
// Authentication and security settings:
// 
/////////////////////////////////////////////////////////////////////

// If set, we will perform reverse dns lookups to try to convert the users
// IP number to a host name, even if the http server didn't do it for us.
define('ENABLE_REVERSE_DNS', false);

// ID ȣԴϴ. ̰͵ Ƿ 
//ϸ ˴ϴ.  ̳ MySQL ϰ 
// ϴ.
//ȣ adminps ̿  ݵ ϼ.

//<!-- gryu+
define('ADMIN_USER', "DbWiki");
define('ADMIN_PASSWD', "adminps");
//--> gryu +

// true̸ ڸ ZIP Ϸ   ֽϴ.
define('ZIPDUMP_AUTH', true);

//  ε  ϴ. ׳ νñ
define('MAX_UPLOAD_SIZE', 16 * 1024 * 1024);

//   ڰ ̾   ڵ " " üũ˴ϴ.
// ׷    ð Ʒ ð  
//   ƴ  ֵ˴ϴ.
define("MINOR_EDIT_TIMEOUT", 7 * 24 * 3600);

//   ׼ մϴ.
//$DisabledActions = array('dumpserial', 'loadfile');

// PhpWiki can generate an access_log (in "NCSA combined log" format)
// for you.  If you want one, define this to the name of the log file.
define('ACCESS_LOG', '/tmp/wiki_access_log');


// If ALLOW_BOGO_LOGIN is true, users are allowed to login
// (with any/no password) using any userid which: 1) is not
// the ADMIN_USER, 2) is a valid WikiWord (matches $WikiNameRegexp.)
//    ߰ǾǷ    ǹ̰ .
define('ALLOW_BOGO_LOGIN', true);

// The login code now uses PHP's session support.  Usually, the default
// configuration of PHP is to store the session state information in
// /tmp.  That probably will work fine, but fails e.g. on clustered
// servers where each server has their own distinct /tmp (this
// is the case on SourceForge's project web server.)  You can specify
// an alternate directory in which to store state information like so
// (whatever user your httpd runs as must have read/write permission
// in this directory):
//    .  Ư   ǵ帱 ʿ䰡 ϴ.
// ini_set('session.save_path', 'some_other_directory');


/////////////////////////////////////////////////////////////////////
//
// Part Two:
// Database Selection
//
/////////////////////////////////////////////////////////////////////

//
// This array holds the parameters which select the database to use.
//
// Not all of these parameters are used by any particular DB backend.
//
$DBParams = array(
   // DB .  MySQL մϴ. 'SQL'  MySQL մϴ.
   'dbtype' => 'SQL',
 
   //  MySQL   մϴ. ´ 
   
   // mysql://user:password@host/databasename  Դϴ.
   
    //user, password  MySQL ID ȣ̱. 
    // host κ  localhost ϸ ˴ϴ. 
   // databasename DB ̸  Ǳ.  ȣ  Ƹ  
   // ̸ ϰų  ̸ ڿ DB ٴ  Դϴ(Ȯ  
   // ڿ Ͻñ).
//<!--
   'dsn' => 'mysql://dbuser:dbpasswd@localhost/dbname',
//-->   
   // Used by all DB types:

//̺ ξ. ̰ ٲٸ schemas/dbwiki.schema.mysql  ̺ ̸鵵  
// ٲ մϴ.
   'prefix' => 'dbwiki_',
   
   // 'dba' ̴ . ǵ帱 ʿ .
   'directory' => "/tmp",
   'dba_handler' => 'gdbm',   // Either of 'gdbm' or 'db2' work great for me.
   //'dba_handler' => 'db2',
   //'dba_handler' => 'db3',    // doesn't work at all for me....
   'timeout' => 20,
   //'timeout' => 5
);

/////////////////////////////////////////////////////////////////////

// ֵ  8  . ׷ 1  ̻ ƴ.
$ExpireParams['major'] = array('max_age' => 32,
                               'keep'	   => 8);
//   4  , ׷ 1  ̻ ƴ.
$ExpireParams['minor'] = array('max_age' => 7,
                               'keep'    => 4);
// 1Ⱓ ֱ  8   .
//      1 ϰ  ڵ(8  ̻ ) .
//      20  .

$ExpireParams['author'] = array('max_age'  => 365,
                                'keep'     => 8,
                                'min_age'  => 7,
                                'max_keep' => 20);

/////////////////////////////////////////////////////////////////////
// 
// Part Three:
// Page appearance and layout
//
/////////////////////////////////////////////////////////////////////

// ѱ   Ͼϴ. ˻     
// 'C' صξ մϴ.
$LANG='C';
//$LANG='nl_NL';

//   ̸

define('HOME_PAGE', 'HomePage');

// CSS  ġ
//
// CSS  ġԴϴ. index.php ִ   
//ġ ϸ ˴ϴ. ⺻ dbwiki.css Դϴ.
define("CSS_URL", "dbwiki.css");

//ΰ ̹ ġ.  index.php 
$logo = "images/dbwiki.png";


//   (  )
define("NUM_RELATED_PAGES", 5);

//ѱ ڵ  
$encoding = 'utf-8';
//$encoding = 'euc-kr';

//޽, ø 
// templates͸ Ʒ  (  ϳ) ġؾ .

$template_dir = "templates/$encoding";

include "$template_dir/messages.php";

// ø ϵ. index.php .
$templates = array("BROWSE" =>    "$template_dir/dbwikibrowse.html",
		"SIMPLEBROWSE" => "$template_dir/simplebrowse.html",
		"EDITPAGE" =>  "$template_dir/editpage.html",
		"MESSAGE" =>   "$template_dir/message.html",
		"HTMLSOURCE" => "$template_dir/htmlsource.html",
		"DOCBOOKSOURCE" => "$template_dir/docbooksource.html"
		);

// DbWiki    ڵ Ǵ  ⺻ 
//   ִ ZIP  Ǵ 
//  ϵ   丮 ̸ ϸ ˴ϴ.
// ⺻ ڵ  pgsrc/pgsrc_euc-kr.zip Ǵ pgsrc/pgsrc_utf-8.zip Դϴ.
define('WIKI_PGSRC', "pgsrc/pgsrc_$encoding.zip");
//define('WIKI_PGSRC', 'temp');


/////////////////////////////////////////////////////////////////////
//
// Part four:
// Mark-up options.
// 
/////////////////////////////////////////////////////////////////////

// DbWiki ڵ ν URL ݵ
$AllowedProtocols = "http|https|mailto|ftp|news|gopher";

// DbWiki ڵ ν ̹ Ȯڵ
$InlineImages = "png|jpg|gif|eps|tiff";

// DbWiki ڵ ν  Ű ̸ .
$WikiNameRegexp = "(?<![0-9A-Za-z])([A-Z][a-z]+){2,}(?![0-9A-Za-z])";

// ⺻ DTD
$DefaultDTD = 'PUBLIC "-//OASIS//DTD DocBook XML V4.4//EN" "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd"';

//  Ű  InterWikiMap Ű  Ǹ, Ʒ  Ű 
// ϰ մϴ.
//   Ű  θ Ǵϴ   Դϴ(Ű
//     ּ óϼ).
define('INTERWIKI_MAP_FILE', "lib/interwiki.map");

/////////////////////////////////////////////////////////////////////
//
// Part five:
// URL options -- you can probably skip this section.
//
/////////////////////////////////////////////////////////////////////
/******************************************************************
 *
 *  ũ  Ȱɸų ߸  Ű 쿡 
 * ϸ ˴ϴ.
 *
 ******************************************************************/

/*
 * Canonical name and httpd port of the server on which this
 * PhpWiki resides.
 */
//define('SERVER_NAME', 'some.host.com');
//define('SERVER_PORT', 80);

/*
 * Absolute URL (from the server root) of the PhpWiki
 * script.
 */
//define('SCRIPT_NAME', '/dbwiki/index.php');

/*
 * Absolute URL (from the server root) of the directory
 * in which relative URL's for images and other support files
 * are interpreted.
 */
//define('DATA_PATH', '/some/where');

/*
 * Define to 'true' to use PATH_INFO to pass the pagename's.
 * e.g. http://www.some.where/index.php/HomePage instead
 * of http://www.some.where/index.php?pagename=HomePage
 * FIXME: more docs (maybe in README).
 */
//define('USE_PATH_INFO', false);

/*
 * VIRTUAL_PATH is the canonical URL path under which your
 * your wiki appears.  Normally this is the same as
 * dirname(SCRIPT_NAME), however using, e.g. apaches mod_actions
 * (or mod_rewrite), you can make it something different.
 *
 * If you do this, you should set VIRTUAL_PATH here.
 *
 * E.g. your phpwiki might be installed at at /scripts/phpwiki/index.php,
 * but  * you've made it accessible through eg. /wiki/HomePage.
 *
 * One way to do this is to create a directory named 'wiki' in your
 * server root.  The directory contains only one file: an .htaccess
 * file which reads something like:
 *
 *    Action x-phpwiki-page /scripts/phpwiki/index.php
 *    SetHandler x-phpwiki-page
 *    DirectoryIndex /scripts/phpwiki/index.php
 *
 * In that case you should set VIRTUAL_PATH to '/wiki'.
 *
 * (VIRTUAL_PATH is only used if USE_PATH_INFO is true.)
 */
//define('VIRTUAL_PATH', '/dbwiki/index.php');

include "lib/config.php";

// ¥, ð . PHP strftime Լ ̴ Ͱ  Դϴ.
// http://www.php.net/manual/en/function.strftime.php .
$datetimeformat = _T('datetimeformat');	// ð   
$dateformat = _T('dateformat');	// ð ϸ   .


if ( USE_PATH_INFO && $_SERVER['PATH_INFO'] == '' )
{
//  index.php ٸ ̸(wiki.php ) ٲٸ ⼭ ٲ մϴ.	
	header("Location: index.php/"); 
	exit;
}

////////////////////////////////////////////////////////////////
// Okay... fire up the code:
////////////////////////////////////////////////////////////////
include "lib/main.php";

// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
