<?php
require_once('lib/Template.php');
include_once( WikiToDocbookPath . '/w2dclass.php');
function outputDocBook($dbi, $request, $style='') {

	$pagename = $request->getArg('pagename');
	$version = $request->getArg('version');
	
	$page = $dbi->getPage($pagename);
	if ($version) {
		$revision = $page->getRevision($version);
		if (!$revision)
			NoSuchRevision($page, $version);
	}
	else {
		$revision = $page->getCurrentRevision();
	}
	
	$template = new WikiTemplate('DOCBOOKSOURCE');

	$DocInfo = array();

	$DocInfo['TopLevelName'] = 'article';
	$DocInfo['IncludeXmlDeclaration'] = true;
	$DocInfo['IncludeDtdDeclaration'] = false;
	$DocInfo['DtdPath'] = '';
	$DocInfo['indent'] = '';
	$DocInfo['FirstSection'] = 'section';
	$DocInfo['PageName'] = $pagename;

	if ($request->getArg('imgdir') != '')
		$DocInfo['ImageDir'] = $request->getArg('imgdir');

	$Converter = new WikiToDocBook( $DocInfo );
	
	$template->setPageRevisionTokens($revision);
	if ( $request->getArg('action') == 'docbookxml' )
	{
		header ('Expires: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
		header ('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header ('Content-Type: text/xml');
		echo trim($Converter->convert( $revision->getContent()) );
		exit;
	}
	else
	{
		$template->replace('CONTENT', 
			trim(htmlspecialchars(
			$Converter->convert( $revision->getContent())
			)) 
		);
	}
	echo $template->getExpansion() ;
	flush();
}

// For emacs users
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:

?>
