<?php // -*-php-*-
rcs_id('$Id: FullTextSearch.php,v 1.4 2004/03/25 08:15:44 gryu Exp $');

require_once('lib/TextSearchQuery.php');

/**
 */
class WikiPlugin_FullTextSearch
extends	WikiPlugin
{
	var	$name =	'FullTextSearch';

	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array('s' => false,
			 'noheader' => false
		);
	}

	function getDefaultFormArguments() {
		$defaults =	parent::getDefaultFormArguments();
		$defaults['description'] = _T('full_text_search');
		$defaults['buttontext'] = _T('full_text_search');
		
		return $defaults;
	}
		
	function run($dbi, $argstr,	$request) {
		$args =	$this->getArgs($argstr,	$request);
		if (empty($args['s']))
			return '';
        
		extract($args);
		if (strlen(chop($s)) < 3) {
			$html = _T('keyword_too_short');
		} else {
			$query = new TextSearchQuery($s);
			$pages = $dbi->fullSearch($query);
			$lines = array();
			$hilight_re	= $query->getHighlightRegexp();
			$count = 0;
			$found = 0;
			while ($page = $pages->next()) {
				$count++;
				$name =	$page->getName();
				$lines[] = Element('dt', LinkExistingWikiWord($name));
				if ($hilight_re)
					$lines[] = $this->showhits($page, $hilight_re);
			}
        
			$html =	'';
        	
			if (!$noheader)
				$html .= QElement('p',
					sprintf(_T('full_text_search_result'), $s));
			if (!$lines)
				$lines[] = QElement('dd', _T('none') );
			$html .= Element('dl', join("\n", $lines));
		}
		return $html;
	}   	
    	
	function showhits($page, $hilight_re) {
		$FS	= &$GLOBALS['FieldSeparator'];
		$current = $page->getCurrentRevision();
		$matches = preg_grep("/$hilight_re/i", $current->getContent());
		$html =	'';
		foreach	($matches as $line)	{
			$line =	str_replace($FS, '', $line);
			$line =	preg_replace("/$hilight_re/i", "${FS}OT\\0${FS}CT",	$line);
			$line =	htmlspecialchars($line);
			$line =	str_replace("${FS}OT", '<b>', $line);
			$line =	str_replace("${FS}CT", '</b>', $line);
			$html .= Element('dd', Element('small',	$line))	. "\n";
		}
		return $html;
	}

	function make_form($args) {
		// FIXME: need more	thought	about this whole interface.
		$args['search']	= '()';
		return MakeWikiForm($GLOBALS['pagename'], $args, 'wikiaction', _T('full_text_search'));
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:	  
?>
