Params = {}
function Params.parse_line(line)
	local result = ''
	for k, v in string.gfind(line, "([.%w]+)%s*=%s*(.+)") do
		if type(tonumber(v))=="number" then
			result = " --param " .. k .. " " .. v
		else
			v = string.gsub(v, "(.-)%s*$", "%1")
			result = " --stringparam " .. k .. " \"" .. v .. "\""
		end
	end
	return result
end

function Params.get_params(filename)
	io.input(filename)
	local result = ''
	while true do
		local line = io.read()
		if not line then break end
		if string.len(line) == 0 then break end
		if string.sub(line, 1, 1) ~= '#' then -- # ּ
			result = result .. Params.parse_line(line)
		end
	end
	return result
end
