/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.java2d.FontSetup;
import org.apache.fop.svg.SVGUtilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SVGRenderer
extends AbstractRenderer {
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private Document svgDocument;
    private Element svgRoot;
    private Element currentPageG = null;
    private Element lastLink = null;
    private String lastViewbox = null;
    private Element docDefs = null;
    private Element pageDefs = null;
    private Element pagesGroup = null;
    private LineArea docTitle = null;
    private OutputStream ostream;
    private float totalWidth = 0.0f;
    private float totalHeight = 0.0f;
    private float sequenceWidth = 0.0f;
    private float sequenceHeight = 0.0f;
    private float pageWidth = 0.0f;
    private float pageHeight = 0.0f;
    private int pageNumber = 0;
    private HashMap fontNames = new HashMap();
    private HashMap fontStyles = new HashMap();
    private Color saveColor = null;
    private String currentFontName;
    private int currentFontSize;
    private float currentRed = 0.0f;
    private float currentGreen = 0.0f;
    private float currentBlue = 0.0f;

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        XMLHandler handler = agent.getXMLHandlerRegistry().getXMLHandler((Renderer)this, SVG_NAMESPACE);
        if (handler == null) {
            agent.getXMLHandlerRegistry().addXMLHandler("org.apache.fop.render.svg.SVGSVGHandler");
        }
    }

    public void setupFontInfo(FontInfo fontInfo) {
        BufferedImage fontImage = new BufferedImage(1, 1, 1);
        FontSetup.setup((FontInfo)fontInfo, (Graphics2D)fontImage.createGraphics());
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.ostream = outputStream;
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        this.svgDocument = impl.createDocument(SVG_NAMESPACE, "svg", null);
        this.svgRoot = this.svgDocument.getDocumentElement();
        this.docDefs = this.svgDocument.createElementNS(SVG_NAMESPACE, "defs");
        this.svgRoot.appendChild(this.docDefs);
        this.pagesGroup = this.svgDocument.createElementNS(SVG_NAMESPACE, "g");
        this.pageDefs = this.svgDocument.createElementNS(SVG_NAMESPACE, "defs");
        this.pagesGroup.appendChild(this.pageDefs);
        this.svgRoot.appendChild(this.pagesGroup);
    }

    public void stopRenderer() throws IOException {
        this.totalWidth += this.sequenceWidth;
        if (this.sequenceHeight > this.totalHeight) {
            this.totalHeight = this.sequenceHeight;
        }
        this.svgRoot.setAttributeNS(null, "width", "" + (this.totalWidth + 1.0f));
        this.svgRoot.setAttributeNS(null, "height", "" + (this.totalHeight + 1.0f));
        SVGTranscoder svgT = new SVGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svgDocument);
        TranscoderOutput output = new TranscoderOutput((Writer)new OutputStreamWriter(this.ostream));
        try {
            svgT.transcode(input, output);
        }
        catch (TranscoderException e) {
            log.error((Object)("could not write svg file :" + e.getMessage()), (Throwable)e);
        }
        this.ostream.flush();
        this.ostream = null;
        this.svgDocument = null;
        this.svgRoot = null;
        this.currentPageG = null;
        this.lastLink = null;
        this.totalWidth = 0.0f;
        this.totalHeight = 0.0f;
        this.pageNumber = 0;
    }

    public void startPageSequence(LineArea seqTitle) {
        this.totalWidth += this.sequenceWidth;
        if (this.sequenceHeight > this.totalHeight) {
            this.totalHeight = this.sequenceHeight;
        }
        this.sequenceWidth = 0.0f;
        this.sequenceHeight = 0.0f;
        if (seqTitle != null && this.docTitle == null) {
            this.docTitle = seqTitle;
            String str = this.convertTitleToString(seqTitle);
            Element svgTitle = this.svgDocument.createElementNS(SVG_NAMESPACE, "title");
            Text strNode = this.svgDocument.createTextNode(str);
            svgTitle.appendChild(strNode);
            this.svgRoot.insertBefore(svgTitle, this.svgRoot.getFirstChild());
        }
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        float lastWidth = this.pageWidth;
        float lastHeight = this.pageHeight;
        Rectangle2D area = page.getViewArea();
        this.pageWidth = (float)area.getWidth() / 1000.0f;
        this.pageHeight = (float)area.getHeight() / 1000.0f;
        if (this.lastLink != null) {
            this.lastLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(" + this.totalWidth + ", " + this.sequenceHeight + ", " + this.pageWidth + ", " + this.pageHeight + "))");
            this.pagesGroup.appendChild(this.lastLink);
        }
        this.currentPageG = this.svgDocument.createElementNS(SVG_NAMESPACE, "svg");
        this.currentPageG.setAttributeNS(null, "viewbox", "0 0 " + (int)this.pageWidth + " " + (int)this.pageHeight);
        this.currentPageG.setAttributeNS(null, "width", "" + ((int)this.pageWidth + 1));
        this.currentPageG.setAttributeNS(null, "height", "" + ((int)this.pageHeight + 1));
        this.currentPageG.setAttributeNS(null, "id", "Page-" + this.pageNumber);
        this.currentPageG.setAttributeNS(null, "style", "font-family:sanserif;font-size:12");
        this.pageDefs.appendChild(this.currentPageG);
        if (this.pageWidth > this.sequenceWidth) {
            this.sequenceWidth = this.pageWidth;
        }
        this.sequenceHeight += this.pageHeight;
        Element border = SVGUtilities.createRect((Document)this.svgDocument, (float)0.0f, (float)0.0f, (float)this.pageWidth, (float)this.pageHeight);
        border.setAttributeNS(null, "style", "fill:none;stroke:black");
        this.currentPageG.appendChild(border);
        super.renderPage(page);
        Element use = this.svgDocument.createElementNS(SVG_NAMESPACE, "use");
        use.setAttributeNS(null, "xlink:href", "#Page-" + this.pageNumber);
        use.setAttributeNS(null, "x", "" + this.totalWidth);
        use.setAttributeNS(null, "y", "" + (this.sequenceHeight - this.pageHeight));
        this.pagesGroup.appendChild(use);
        Element lastPageLink = this.svgDocument.createElementNS(SVG_NAMESPACE, "a");
        if (this.lastLink != null) {
            lastPageLink.setAttributeNS(null, "xlink:href", this.lastViewbox);
        } else {
            lastPageLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(" + this.totalWidth + ", " + (this.sequenceHeight - this.pageHeight) + ", " + this.pageWidth + ", " + this.pageHeight + "))");
        }
        this.pagesGroup.appendChild(lastPageLink);
        Element rect = SVGUtilities.createRect((Document)this.svgDocument, (float)this.totalWidth, (float)(this.sequenceHeight - this.pageHeight), (float)(this.pageWidth / 2.0f), (float)this.pageHeight);
        rect.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        lastPageLink.appendChild(rect);
        this.lastLink = this.svgDocument.createElementNS(SVG_NAMESPACE, "a");
        rect = SVGUtilities.createRect((Document)this.svgDocument, (float)(this.totalWidth + this.pageWidth / 2.0f), (float)(this.sequenceHeight - this.pageHeight), (float)(this.pageWidth / 2.0f), (float)this.pageHeight);
        rect.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        this.lastLink.appendChild(rect);
        this.lastViewbox = "#svgView(viewBox(" + this.totalWidth + ", " + (this.sequenceHeight - this.pageHeight) + ", " + this.pageWidth + ", " + this.pageHeight + "))";
        ++this.pageNumber;
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext((AbstractRenderer)this, this.getMimeType());
        context.setUserAgent(this.userAgent);
        context.setProperty("svgDoc", (Object)this.svgDocument);
        context.setProperty("svgPageG", (Object)this.currentPageG);
        context.setProperty("xpos", (Object)new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", (Object)new Integer(this.currentBPPosition + (int)pos.getY()));
        context.setProperty("width", (Object)new Integer((int)pos.getWidth()));
        context.setProperty("height", (Object)new Integer((int)pos.getHeight()));
        this.renderXML(context, doc, ns);
    }

    public void renderLeader(Leader area) {
        String style = "stroke:black;stroke-width:" + area.getRuleThickness() / 1000 + ";";
        switch (area.getRuleStyle()) {
            case 36: {
                style = style + "stroke-dasharray:1,1";
                break;
            }
            case 31: {
                style = style + "stroke-dasharray:5,1";
                break;
            }
            case 133: {
                break;
            }
            case 37: {
                break;
            }
            case 55: {
                break;
            }
        }
        Element line = SVGUtilities.createLine((Document)this.svgDocument, (float)(this.currentIPPosition / 1000), (float)((this.currentBPPosition + area.getOffset() - area.getRuleThickness() / 2) / 1000), (float)((this.currentIPPosition + area.getIPD()) / 1000), (float)((this.currentBPPosition + area.getOffset() - area.getRuleThickness() / 2) / 1000));
        line.setAttributeNS(null, "style", style);
        this.currentPageG.appendChild(line);
        super.renderLeader(area);
    }

    public void renderText(TextArea text) {
        Element textElement = SVGUtilities.createText((Document)this.svgDocument, (float)(this.currentIPPosition / 1000), (float)((this.currentBPPosition + text.getOffset() + text.getBaselineOffset()) / 1000), (String)text.getText());
        this.currentPageG.appendChild(textElement);
        super.renderText(text);
    }

    public String getMimeType() {
        return SVG_MIME_TYPE;
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
    }

    protected void endVParea() {
    }

    protected void renderInlineAreaBackAndBorders(InlineArea area) {
    }
}

