/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Root;
import org.xml.sax.Locator;

public class Declarations
extends FObj {
    private Map colorProfiles = null;

    public Declarations(FONode parent) {
        super(parent);
        ((Root)parent).setDeclarations(this);
    }

    public void bind(PropertyList pList) throws FOPException {
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && !localName.equals("color-profile")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes != null) {
            Iterator iter = this.childNodes.iterator();
            while (iter.hasNext()) {
                FONode node = (FONode)iter.next();
                if (node.getName().equals("fo:color-profile")) {
                    ColorProfile cp = (ColorProfile)node;
                    if (!"".equals(cp.getColorProfileName())) {
                        this.addColorProfile(cp);
                        continue;
                    }
                    log.warn((Object)"color-profile-name required for color profile");
                    continue;
                }
                log.debug((Object)("Ignoring element " + node.getName() + " inside fo:declarations."));
            }
        }
        this.childNodes = null;
    }

    private void addColorProfile(ColorProfile cp) {
        if (this.colorProfiles == null) {
            this.colorProfiles = new HashMap();
        }
        if (this.colorProfiles.get(cp.getColorProfileName()) != null) {
            log.warn((Object)("Duplicate fo:color-profile profile name: " + cp.getColorProfileName()));
        }
        this.colorProfiles.put(cp.getColorProfileName(), cp);
    }

    public String getLocalName() {
        return "declarations";
    }

    public int getNameId() {
        return 8;
    }

    public ColorProfile getColorProfile(String cpName) {
        ColorProfile profile = null;
        if (this.colorProfiles != null) {
            profile = (ColorProfile)this.colorProfiles.get(cpName);
        }
        return profile;
    }
}

