/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSGraphics2DAdapter;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.PSState;
import org.w3c.dom.Document;

public class PSRenderer
extends AbstractPathOrientedRenderer
implements ImageAdapter {
    public static final String MIME_TYPE = "application/postscript";
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    protected PSGenerator gen;
    private boolean ioTrouble = false;
    private boolean inTextMode = false;
    private boolean firstPageSequenceReceived = false;
    private List setupCodeList;
    private Map fontResources;

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        this.autoRotateLandscape = cfg.getChild("auto-rotate-landscape").getValueAsBoolean(false);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
    }

    public void setAutoRotateLandscape(boolean value) {
        this.autoRotateLandscape = value;
    }

    public boolean isAutoRotateLandscape() {
        return this.autoRotateLandscape;
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PSGraphics2DAdapter(this);
    }

    public ImageAdapter getImageAdapter() {
        return this;
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            log.error((Object)"Error while writing to target file", (Throwable)ioe);
            this.ioTrouble = true;
        }
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            if (comment.startsWith("%")) {
                this.writeln(comment);
            } else {
                this.writeln("%" + comment);
            }
        }
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void clip() {
        this.writeln("clip newpath");
    }

    protected void clipRect(float x, float y, float width, float height) {
        try {
            this.gen.defineRect((double)x, (double)y, (double)width, (double)height);
            this.clip();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void moveTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " M");
    }

    protected void rmoveTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " RM");
    }

    protected void lineTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " lineto");
    }

    protected void closePath() {
        this.writeln("cp");
    }

    protected void fillRect(float x, float y, float width, float height) {
        if (width != 0.0f && height != 0.0f) {
            try {
                this.gen.defineRect((double)x, (double)y, (double)width, (double)height);
                this.gen.writeln("fill");
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
    }

    protected void updateColor(Color col, boolean fill) {
        try {
            this.useColor(col);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void drawImage(String url, Rectangle2D pos, Map foreignAttributes) {
        this.endTextObject();
        url = ImageFactory.getURL((String)url);
        ImageFactory fact = this.userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        float x = (float)pos.getX() / 1000.0f;
        x += (float)this.currentIPPosition / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        y += (float)this.currentBPPosition / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        try {
            String mime = fopimage.getMimeType();
            if ("text/xml".equals(mime)) {
                if (!fopimage.load(2)) {
                    return;
                }
                Document doc = ((XMLImage)fopimage).getDocument();
                String ns = ((XMLImage)fopimage).getNameSpace();
                this.renderDocument(doc, ns, pos, foreignAttributes);
            } else if ("image/svg+xml".equals(mime)) {
                if (!fopimage.load(2)) {
                    return;
                }
                Document doc = ((XMLImage)fopimage).getDocument();
                String ns = ((XMLImage)fopimage).getNameSpace();
                this.renderDocument(doc, ns, pos, foreignAttributes);
            } else if (fopimage instanceof EPSImage) {
                PSImageUtils.renderEPS((EPSImage)fopimage, x, y, w, h, this.gen);
            } else {
                PSImageUtils.renderBitmapImage(fopimage, x, y, w, h, this.gen);
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void paintImage(RenderedImage image, RendererContext context, int x, int y, int width, int height) throws IOException {
        float fx = (float)x / 1000.0f;
        x = (int)((float)x + (float)this.currentIPPosition / 1000.0f);
        float fy = (float)y / 1000.0f;
        y = (int)((float)y + (float)this.currentBPPosition / 1000.0f);
        float fw = (float)width / 1000.0f;
        float fh = (float)height / 1000.0f;
        PSImageUtils.renderBitmapImage((RenderedImage)image, (float)fx, (float)fy, (float)fw, (float)fh, (PSGenerator)this.gen);
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.writeln(this.gen.formatDouble((double)startx) + " " + this.gen.formatDouble((double)starty) + " M " + this.gen.formatDouble((double)endx) + " " + this.gen.formatDouble((double)endy) + " lineto stroke newpath");
    }

    public void saveGraphicsState() {
        this.endTextObject();
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void restoreGraphicsState() {
        try {
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void useFont(String name, int size) {
        try {
            this.gen.useFont(name, (float)size / 1000.0f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private void useColor(Color col) throws IOException {
        this.gen.useRGBColor(col);
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        if (area.hasTrait((Object)Trait.BACKGROUND) || area.hasTrait((Object)Trait.BORDER_BEFORE) || area.hasTrait((Object)Trait.BORDER_AFTER) || area.hasTrait((Object)Trait.BORDER_START) || area.hasTrait((Object)Trait.BORDER_END)) {
            this.comment("%FOPBeginBackgroundAndBorder: " + startx + " " + starty + " " + width + " " + height);
            super.drawBackAndBorders(area, startx, starty, width, height);
            this.comment("%FOPEndBackgroundAndBorder");
        }
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        try {
            float w = x2 - x1;
            float h = y2 - y1;
            if (w < 0.0f || h < 0.0f) {
                log.error((Object)"Negative extent received. Border won't be painted.");
                return;
            }
            switch (style) {
                case 31: {
                    this.useColor(col);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[" + unit + "] 0");
                        this.gen.useLineCap(0);
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[" + unit + "] 0");
                    this.gen.useLineCap(0);
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 36: {
                    this.useColor(col);
                    this.gen.useLineCap(1);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[0 " + unit + "] 0");
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[0 " + unit + "] 0");
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 37: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    if (horz) {
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth((double)h3);
                        float ym1 = y1 + h3 / 2.0f;
                        float ym2 = ym1 + h3 + h3;
                        this.drawLine(x1, ym1, x2, ym1);
                        this.drawLine(x1, ym2, x2, ym2);
                        break;
                    }
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth((double)w3);
                    float xm1 = x1 + w3 / 2.0f;
                    float xm2 = xm1 + w3 + w3;
                    this.drawLine(xm1, y1, xm1, y2);
                    this.drawLine(xm2, y1, xm2, y2);
                    break;
                }
                case 55: 
                case 119: {
                    float colFactor = style == 55 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    if (horz) {
                        Color uppercol = PSRenderer.lightenColor((Color)col, (float)(-colFactor));
                        Color lowercol = PSRenderer.lightenColor((Color)col, (float)colFactor);
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth((double)h3);
                        float ym1 = y1 + h3 / 2.0f;
                        this.gen.useRGBColor(uppercol);
                        this.drawLine(x1, ym1, x2, ym1);
                        this.gen.useRGBColor(col);
                        this.drawLine(x1, ym1 + h3, x2, ym1 + h3);
                        this.gen.useRGBColor(lowercol);
                        this.drawLine(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3);
                        break;
                    }
                    Color leftcol = PSRenderer.lightenColor((Color)col, (float)(-colFactor));
                    Color rightcol = PSRenderer.lightenColor((Color)col, (float)colFactor);
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth((double)w3);
                    float xm1 = x1 + w3 / 2.0f;
                    this.gen.useRGBColor(leftcol);
                    this.drawLine(xm1, y1, xm1, y2);
                    this.gen.useRGBColor(col);
                    this.drawLine(xm1 + w3, y1, xm1 + w3, y2);
                    this.gen.useRGBColor(rightcol);
                    this.drawLine(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2);
                    break;
                }
                case 67: 
                case 101: {
                    float colFactor = style == 101 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    if (horz) {
                        Color c = PSRenderer.lightenColor((Color)col, (float)((float)(startOrBefore ? 1 : -1) * colFactor));
                        this.gen.useLineWidth((double)h);
                        float ym1 = y1 + h / 2.0f;
                        this.gen.useRGBColor(c);
                        this.drawLine(x1, ym1, x2, ym1);
                        break;
                    }
                    Color c = PSRenderer.lightenColor((Color)col, (float)((float)(startOrBefore ? 1 : -1) * colFactor));
                    this.gen.useLineWidth((double)w);
                    float xm1 = x1 + w / 2.0f;
                    this.gen.useRGBColor(c);
                    this.drawLine(xm1, y1, xm1, y2);
                    break;
                }
                case 57: {
                    break;
                }
                default: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    this.gen.useLineCap(0);
                    if (horz) {
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug((Object)"rendering areas to PostScript");
        this.gen = new PSGenerator(outputStream){

            public Source resolveURI(String uri) {
                return PSRenderer.this.userAgent.resolveURI(uri);
            }
        };
        this.currentPageNumber = 0;
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", (Object[])new String[]{this.userAgent.getProducer()});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("LanguageLevel", (Object)new Integer(this.gen.getPSLevel()));
        this.gen.writeDSCComment("Pages", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("DocumentSuppliedResources", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
    }

    public void stopRenderer() throws IOException {
        Map fonts = this.fontInfo.getUsedFonts();
        Iterator e = fonts.keySet().iterator();
        while (e.hasNext()) {
            String key = (String)e.next();
            PSResource res = (PSResource)this.fontResources.get(key);
            boolean supplied = this.gen.isResourceSupplied(res);
            if (supplied) continue;
            this.gen.notifyResourceUsage(res, true);
        }
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", (Object)new Integer(this.currentPageNumber));
        this.gen.writeResources(false);
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public void processOffDocumentItem(OffDocumentItem oDI) {
        ExtensionAttachment attachment;
        log.debug((Object)("Handling OffDocumentItem: " + oDI.getName()));
        if (oDI instanceof OffDocumentExtensionAttachment && "apache:fop:extensions:postscript".equals((attachment = ((OffDocumentExtensionAttachment)oDI).getAttachment()).getCategory())) {
            PSSetupCode setupCode = (PSSetupCode)attachment;
            if (this.setupCodeList == null) {
                this.setupCodeList = new ArrayList();
            }
            this.setupCodeList.add(setupCode);
        }
        super.processOffDocumentItem(oDI);
    }

    public void startPageSequence(LineArea seqTitle) {
        super.startPageSequence(seqTitle);
        if (!this.firstPageSequenceReceived) {
            try {
                this.gen.writeDSCComment("BeginProlog");
                PSProcSets.writeFOPStdProcSet((PSGenerator)this.gen);
                PSProcSets.writeFOPEPSProcSet((PSGenerator)this.gen);
                this.gen.writeDSCComment("EndProlog");
                this.gen.writeDSCComment("BeginSetup");
                this.writeSetupCodeList(this.setupCodeList, "SetupCode");
                this.fontResources = PSFontUtils.writeFontDict(this.gen, this.fontInfo);
                this.gen.writeln("FOPFonts begin");
                this.gen.writeDSCComment("EndSetup");
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
            this.firstPageSequenceReceived = true;
        }
    }

    private void writeSetupCodeList(List setupCodeList, String type) throws IOException {
        if (setupCodeList != null) {
            Iterator i = setupCodeList.iterator();
            while (i.hasNext()) {
                String line;
                PSSetupCode setupCode = (PSSetupCode)i.next();
                this.gen.commentln("%FOPBegin" + type + ": (" + (setupCode.getName() != null ? setupCode.getName() : "") + ")");
                LineNumberReader reader = new LineNumberReader(new StringReader(setupCode.getContent()));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    this.gen.writeln(line.trim());
                }
                this.gen.commentln("%FOPEnd" + type);
                i.remove();
            }
        }
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        log.debug((Object)("renderPage(): " + page));
        ++this.currentPageNumber;
        this.gen.notifyStartNewPage();
        this.gen.notifyResourceUsage(PSProcSets.STD_PROCSET, false);
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumberString(), new Integer(this.currentPageNumber)});
        Integer zero = new Integer(0);
        long pagewidth = Math.round(page.getViewArea().getWidth());
        long pageheight = Math.round(page.getViewArea().getHeight());
        double pspagewidth = (float)pagewidth / 1000.0f;
        double pspageheight = (float)pageheight / 1000.0f;
        boolean rotate = false;
        if (this.autoRotateLandscape && pageheight < pagewidth) {
            rotate = true;
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspageheight)), new Long(Math.round(pspagewidth))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspageheight), new Double(pspagewidth)});
            this.gen.writeDSCComment("PageOrientation", (Object)"Landscape");
        } else {
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspagewidth)), new Long(Math.round(pspageheight))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspagewidth), new Double(pspageheight)});
            if (this.autoRotateLandscape) {
                this.gen.writeDSCComment("PageOrientation", (Object)"Portrait");
            }
        }
        this.gen.writeDSCComment("PageResources", new Object[]{PSGenerator.ATEND});
        this.gen.commentln("%FOPSimplePageMaster: " + page.getSimplePageMasterName());
        this.gen.writeDSCComment("BeginPageSetup");
        if (page.getExtensionAttachments() != null && page.getExtensionAttachments().size() > 0) {
            ArrayList<ExtensionAttachment> list = new ArrayList<ExtensionAttachment>();
            Iterator i = page.getExtensionAttachments().iterator();
            while (i.hasNext()) {
                ExtensionAttachment attachment = (ExtensionAttachment)i.next();
                if (!"apache:fop:extensions:postscript".equals(attachment.getCategory())) continue;
                list.add(attachment);
            }
            this.writeSetupCodeList(list, "PageSetupCode");
        }
        if (rotate) {
            this.gen.writeln(Math.round(pspageheight) + " 0 translate");
            this.gen.writeln("90 rotate");
        }
        this.gen.writeln("<<");
        this.gen.writeln("/PageSize [" + Math.round(pspagewidth) + " " + Math.round(pspageheight) + "]");
        this.gen.writeln("/ImagingBBox null");
        this.gen.writeln(">> setpagedevice");
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, (float)pageheight / 1000.0f);
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeResources(true);
        this.gen.writeDSCComment("EndPage");
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.comment("%FOPBeginRegionViewport: " + port.getRegionReference().getRegionName());
            super.renderRegionViewport(port);
            this.comment("%FOPEndRegionViewport");
        }
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.saveGraphicsState();
            this.writeln("BT");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        if (this.inTextMode) {
            this.writeln("ET");
            this.restoreGraphicsState();
            this.inTextMode = false;
        }
    }

    public void renderText(TextArea area) {
        this.renderInlineAreaBackAndBorders((InlineArea)area);
        String fontname = this.getInternalFontNameForArea((Area)area);
        int fontsize = area.getTraitAsInteger((Object)Trait.FONT_SIZE);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentIPPosition + area.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + area.getOffset() + area.getBaselineOffset();
        this.useFont(fontname, fontsize);
        Color ct = (Color)area.getTrait((Object)Trait.COLOR);
        if (ct != null) {
            try {
                this.useColor(ct);
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
        this.beginTextObject();
        this.writeln("1 0 0 -1 " + this.gen.formatDouble((double)((float)rx / 1000.0f)) + " " + this.gen.formatDouble((double)((float)bl / 1000.0f)) + " Tm");
        super.renderText(area);
        this.renderTextDecoration(tf, fontsize, (InlineArea)area, bl, rx);
    }

    protected void renderWord(WordArea word) {
        this.renderText((AbstractTextArea)((TextArea)word.getParentArea()), word.getWord(), word.getLetterAdjustArray());
        super.renderWord(word);
    }

    protected void renderSpace(SpaceArea space) {
        AbstractTextArea textArea = (AbstractTextArea)space.getParentArea();
        String s = space.getSpace();
        char sp = s.charAt(0);
        Font font = this.getFontFromArea((Area)textArea);
        int tws = space.isAdjustable() ? ((TextArea)space.getParentArea()).getTextWordSpaceAdjust() + 2 * textArea.getTextLetterSpaceAdjust() : 0;
        this.rmoveTo((float)(font.getCharWidth(sp) + tws) / 1000.0f, 0.0f);
        super.renderSpace(space);
    }

    private void renderText(AbstractTextArea area, String text, int[] letterAdjust) {
        Font font = this.getFontFromArea((Area)area);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        int textLen = text.length();
        if (letterAdjust == null && area.getTextLetterSpaceAdjust() == 0 && area.getTextWordSpaceAdjust() == 0) {
            sb.append("(");
            for (int i = 0; i < textLen; ++i) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                PSGenerator.escapeChar((char)mapped, (StringBuffer)sb);
            }
            sb.append(") t");
        } else {
            int i;
            sb.append("(");
            int[] offsets = new int[textLen];
            for (i = 0; i < textLen; ++i) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                int wordSpace = CharUtilities.isAdjustableSpace((char)mapped) ? area.getTextWordSpaceAdjust() : 0;
                int cw = tf.getWidth(mapped, font.getFontSize()) / 1000;
                int ladj = letterAdjust != null && i < textLen - 1 ? letterAdjust[i + 1] : 0;
                int tls = i < textLen - 1 ? area.getTextLetterSpaceAdjust() : 0;
                offsets[i] = cw + ladj + tls + wordSpace;
                PSGenerator.escapeChar((char)mapped, (StringBuffer)sb);
            }
            sb.append(")\n[");
            for (i = 0; i < textLen; ++i) {
                if (i > 0) {
                    if (i % 8 == 0) {
                        sb.append('\n');
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append(this.gen.formatDouble((double)((float)offsets[i] / 1000.0f)));
            }
            sb.append("]\nxshow");
        }
        this.writeln(sb.toString());
    }

    protected List breakOutOfStateStack() {
        try {
            ArrayList<PSState> breakOutList = new ArrayList<PSState>();
            while (true) {
                if (breakOutList.size() == 0) {
                    this.endTextObject();
                    this.comment("------ break out!");
                }
                PSState state = this.gen.getCurrentState();
                if (!this.gen.restoreGraphicsState()) break;
                breakOutList.add(0, state);
            }
            return breakOutList;
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
            return null;
        }
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        try {
            this.comment("------ restoring context after break-out...");
            Iterator i = breakOutList.iterator();
            while (i.hasNext()) {
                PSState state = (PSState)i.next();
                this.saveGraphicsState();
                state.reestablish(this.gen);
            }
            this.comment("------ done.");
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        double[] matrix = ctm.toArray();
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        this.concatMatrix(matrix);
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        this.comment("%FOPBeginBlockViewport: " + bv.toString());
        super.renderBlockViewport(bv, children);
        this.comment("%FOPEndBlockViewport");
    }

    protected void renderInlineParent(InlineParent ip) {
        super.renderInlineParent(ip);
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders((InlineArea)area);
        this.endTextObject();
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        Color col = (Color)area.getTrait((Object)Trait.COLOR);
        try {
            switch (style) {
                case 31: 
                case 37: 
                case 133: {
                    this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                    break;
                }
                case 36: {
                    this.clipRect(startx, starty, endx - startx, ruleThickness);
                    this.gen.concatMatrix(1.0, 0.0, 0.0, 1.0, (double)(ruleThickness / 2.0f), 0.0);
                    this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                    break;
                }
                case 55: 
                case 119: {
                    float half = (float)area.getRuleThickness() / 2000.0f;
                    this.gen.useRGBColor(PSRenderer.lightenColor((Color)col, (float)0.6f));
                    this.moveTo(startx, starty);
                    this.lineTo(endx, starty);
                    this.lineTo(endx, starty + 2.0f * half);
                    this.lineTo(startx, starty + 2.0f * half);
                    this.closePath();
                    this.gen.writeln(" fill newpath");
                    this.gen.useRGBColor(col);
                    if (style == 55) {
                        this.moveTo(startx, starty);
                        this.lineTo(endx, starty);
                        this.lineTo(endx, starty + half);
                        this.lineTo(startx + half, starty + half);
                        this.lineTo(startx, starty + 2.0f * half);
                    } else {
                        this.moveTo(endx, starty);
                        this.lineTo(endx, starty + 2.0f * half);
                        this.lineTo(startx, starty + 2.0f * half);
                        this.lineTo(startx, starty + half);
                        this.lineTo(endx - half, starty + half);
                    }
                    this.closePath();
                    this.gen.writeln(" fill newpath");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("rule style not supported");
                }
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
        this.restoreGraphicsState();
        super.renderLeader(area);
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.drawImage(image.getURL(), pos);
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("psGenerator", (Object)this.gen);
        context.setProperty("psFontInfo", (Object)this.fontInfo);
        return context;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }
}

