/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

public abstract class AbstractListItemPart
extends FObj {
    private String id;
    private KeepProperty keepTogether;
    private boolean blockItemFound = false;

    public AbstractListItemPart(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.id = pList.get(113).getString();
        this.keepTogether = pList.get(118).getKeep();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            String contentModel = "marker* (%block;)+";
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError(contentModel);
            } else {
                StringBuffer message = new StringBuffer(AbstractListItemPart.errorText(this.getLocator()));
                message.append(this.getName()).append(" is missing child elements. ").append("Required Content Model: ").append(contentModel);
                log.warn((Object)message.toString());
            }
        }
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public String getId() {
        return this.id;
    }
}

