/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.render.mif.MIFElement;
import org.apache.fop.render.mif.PGFElement;
import org.apache.fop.render.mif.RulingElement;

public class MIFFile
extends MIFElement {
    protected MIFElement colorCatalog = null;
    protected PGFElement pgfCatalog = null;
    protected MIFElement fontCatalog = null;
    protected RulingElement rulingCatalog = null;
    protected MIFElement tblCatalog = null;
    protected MIFElement views = null;
    protected MIFElement variableFormats = null;
    protected MIFElement xRefFormats = null;
    protected MIFElement document = null;
    protected MIFElement bookComponent = null;
    protected MIFElement initialAutoNums = null;
    protected MIFElement aFrames = null;
    protected MIFElement tbls = null;
    protected List pages = new ArrayList();
    protected List textFlows = null;

    public MIFFile() {
        super("");
        this.valueElements = new ArrayList();
        this.setup();
    }

    protected void setup() {
        MIFElement unit = new MIFElement("Units");
        unit.setValue("Ucm");
        this.addElement(unit);
        this.colorCatalog = new MIFElement("ColorCatalog");
        MIFElement color = new MIFElement("Color");
        MIFElement prop = new MIFElement("ColorTag");
        prop.setValue("`Black'");
        color.addElement(prop);
        prop = new MIFElement("ColorCyan");
        prop.setValue("0.000000");
        color.addElement(prop);
        prop = new MIFElement("ColorMagenta");
        prop.setValue("0.000000");
        color.addElement(prop);
        prop = new MIFElement("ColorYellow");
        prop.setValue("0.000000");
        color.addElement(prop);
        prop = new MIFElement("ColorBlack");
        prop.setValue("100.000000");
        color.addElement(prop);
        prop = new MIFElement("ColorAttribute");
        prop.setValue("ColorIsBlack");
        color.addElement(prop);
        prop = new MIFElement("ColorAttribute");
        prop.setValue("ColorIsReserved");
        color.addElement(prop);
        color.finish(true);
        this.colorCatalog.addElement(color);
        this.addElement(this.colorCatalog);
        this.pgfCatalog = new PGFElement();
        this.pgfCatalog.lookupElement(null);
        this.addElement(this.pgfCatalog);
        this.rulingCatalog = new RulingElement();
        this.rulingCatalog.lookupElement(null);
        this.addElement(this.rulingCatalog);
    }

    public void output(OutputStream os) throws IOException {
        if (this.finished) {
            return;
        }
        if (!this.started) {
            os.write("<MIFFile  5.00> # Generated by FOP\n".getBytes());
            this.started = true;
        }
        boolean done = true;
        Iterator iter = this.valueElements.iterator();
        while (iter.hasNext()) {
            MIFElement el = (MIFElement)iter.next();
            boolean d = el.output(os, 0);
            if (d) {
                iter.remove();
                continue;
            }
            done = false;
            break;
        }
        if (done && this.finish) {
            os.write("# end of MIFFile".getBytes());
        }
    }

    public void addPage(MIFElement p) {
        this.pages.add(p);
        this.addElement(p);
    }
}

