/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public class NamespaceNode
implements NodeInfo {
    private NodeWrapper parent;
    private String prefix;
    private String uri;

    public NamespaceNode(NodeWrapper nodeWrapper, String string, String string2) {
        this.parent = nodeWrapper;
        this.prefix = string;
        this.uri = string2;
    }

    public void setSystemId(String string) {
    }

    public int getNodeKind() {
        return 13;
    }

    public SequenceIterator getTypedValue(Configuration configuration) {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.uri));
    }

    public NamePool getNamePool() {
        return this.getParent().getNamePool();
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NamespaceNode)) {
            return false;
        }
        if (!((NamespaceNode)nodeInfo).prefix.equals(this.prefix)) {
            return false;
        }
        return nodeInfo.getParent().isSameNodeInfo(this.getParent());
    }

    public String getSystemId() {
        return null;
    }

    public String getBaseURI() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this.isSameNodeInfo(nodeInfo)) {
            return 0;
        }
        if (this.getParent().isSameNodeInfo(nodeInfo.getParent())) {
            if (nodeInfo instanceof NamespaceNode) {
                return this.getDisplayName().compareTo(nodeInfo.getDisplayName());
            }
            return -1;
        }
        return this.getParent().compareOrder(nodeInfo);
    }

    public String getStringValue() {
        return this.uri;
    }

    public int getNameCode() {
        return this.getNamePool().allocate("", "", this.prefix);
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        return this.prefix;
    }

    public String getURI() {
        return "";
    }

    public String getDisplayName() {
        return this.prefix;
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 1: {
                return new Navigator.AncestorEnumeration(this, true);
            }
            case 5: 
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 9: {
                return SingletonIterator.makeIterator(this.parent);
            }
            case 0: {
                return this.parent.iterateAxis((byte)1);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration(this, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration(this);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration(this, false);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(by), nodeTest);
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.parent.getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.parent.getDocumentRoot();
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String generateId() {
        return this.parent.generateId() + 'n' + this.prefix.hashCode();
    }

    public int getDocumentNumber() {
        return this.parent.getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy(this, receiver, this.getNamePool(), n, bl, n2);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) {
    }
}

