/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    Configuration config;

    public Sender(Configuration configuration) {
        this.config = configuration;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean bl) throws XPathException {
        Object object;
        int n;
        receiver.setConfiguration(this.config);
        receiver.setSystemId(source.getSystemId());
        int n2 = n = this.config.isSchemaValidation() ? 1 : 3;
        if (bl) {
            n |= 0x10000;
        }
        if (source instanceof AugmentedSource) {
            object = ((AugmentedSource)source).getSchemaValidation();
            if (object != null) {
                n = ((Boolean)object).booleanValue() ? 1 : 3;
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            int n3;
            if ((n & 0xFF) != 3) {
                try {
                    this.config.getErrorListener().warning(new TransformerException("Validation request ignored for a NodeInfo source"));
                }
                catch (TransformerException transformerException) {
                    throw XPathException.wrap(transformerException);
                }
            }
            if ((n3 = (object = (NodeInfo)source).getNodeKind()) != 9 && n3 != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            this.sendDocumentInfo((NodeInfo)object, receiver, this.config.getNamePool());
        } else if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver, n);
        } else if (source instanceof DOMSource) {
            this.sendDOMSource((DOMSource)source, receiver, n);
        } else if (source instanceof StreamSource) {
            object = (StreamSource)source;
            String string = source.getSystemId();
            InputSource inputSource = new InputSource(string);
            inputSource.setCharacterStream(((StreamSource)object).getReader());
            inputSource.setByteStream(((StreamSource)object).getInputStream());
            SAXSource sAXSource = new SAXSource(this.config.getSourceParser(), inputSource);
            sAXSource.setSystemId(source.getSystemId());
            this.sendSAXSource(sAXSource, receiver, n);
        } else {
            throw new IllegalArgumentException("Unknown type of source " + source.getClass());
        }
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object, NamePool namePool) throws XPathException {
        Object object2;
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendDOMSource(DOMSource dOMSource, Receiver receiver, int n) throws XPathException {
        Node node = dOMSource.getNode();
        if (node instanceof DocumentInfo) {
            this.sendDocumentInfo((DocumentInfo)((Object)node), receiver, this.config.getNamePool());
        } else {
            if ((n & 0xFF) != 3) {
                receiver = this.config.getDocumentValidator(receiver, dOMSource.getSystemId(), this.config.getNamePool(), n);
            }
            DOMSender dOMSender = new DOMSender();
            dOMSender.setStartNode(node);
            dOMSender.setReceiver(receiver);
            dOMSender.setNamePool(this.config.getNamePool());
            dOMSender.setSystemId(dOMSource.getSystemId());
            dOMSender.send();
        }
    }

    private void sendSAXSource(SAXSource sAXSource, Receiver receiver, int n) throws XPathException {
        Object object;
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            object = new SAXSource();
            ((SAXSource)object).setInputSource(sAXSource.getInputSource());
            ((SAXSource)object).setSystemId(sAXSource.getSystemId());
            xMLReader = this.config.getSourceParser();
            ((SAXSource)object).setXMLReader(xMLReader);
            sAXSource = object;
        }
        if (xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(new StandardErrorHandler(this.config.getErrorListener()));
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespaces' feature to true");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespace-prefixes' feature to false");
        }
        if ((n & 0xFF) != 3) {
            receiver = this.config.getDocumentValidator(receiver, sAXSource.getSystemId(), this.config.getNamePool(), n);
        }
        object = new ReceivingContentHandler();
        ((ReceivingContentHandler)object).setReceiver(receiver);
        ((ReceivingContentHandler)object).setConfiguration(this.config);
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            throw new DynamicError(sAXException);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }
}

