/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class Atomizer
extends UnaryExpression
implements MappingFunction {
    public Atomizer(Expression expression) {
        super(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof AtomicValue) {
            return this.operand;
        }
        if (this.operand instanceof Value) {
            Item item;
            SequenceIterator sequenceIterator = this.operand.iterate(null);
            do {
                if ((item = sequenceIterator.next()) != null) continue;
                return this.operand;
            } while (!(item instanceof NodeInfo));
            return this;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (Type.isSubType(this.operand.getItemType(), Type.ANY_ATOMIC_TYPE)) {
            return this.operand;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if (sequenceIterator instanceof AtomizableIterator) {
            ((AtomizableIterator)sequenceIterator).setIsAtomizing(true);
        }
        return new MappingIterator(sequenceIterator, this, null, xPathContext.getController().getConfiguration());
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof NodeInfo) {
            SequenceIterator sequenceIterator = item.getTypedValue(xPathContext.getController().getConfiguration());
            return sequenceIterator.next();
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (item instanceof NodeInfo) {
            return item.getTypedValue((Configuration)object);
        }
        return item;
    }

    public ItemType getItemType() {
        SchemaType schemaType;
        ItemType itemType = this.operand.getItemType();
        if (Type.isSubType(itemType, Type.ANY_ATOMIC_TYPE)) {
            return itemType;
        }
        if (itemType instanceof ContentTypeTest && (schemaType = ((ContentTypeTest)itemType).getSchemaType()) instanceof AtomicType) {
            return (AtomicType)schemaType;
        }
        return Type.ANY_ATOMIC_TYPE;
    }

    public int computeCardinality() {
        return 1792;
    }

    protected String displayOperator(NamePool namePool) {
        return "atomize";
    }
}

