/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class Available
extends SystemFunction
implements XSLTFunction {
    public static final int ELEMENT_AVAILABLE = 0;
    public static final int FUNCTION_AVAILABLE = 1;
    private transient NamespaceResolver nsContext;
    private transient StyleNodeFactory styleNodeFactory;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (!(this.argument[0] instanceof Value) || this.argument.length != 1 && !(this.argument[1] instanceof Value)) {
            this.nsContext = staticContext.getNamespaceResolver();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        String string = ((StringValue)this.argument[0]).getStringValue();
        boolean bl = false;
        switch (this.operation) {
            case 0: {
                bl = ((ExpressionContext)staticContext).isElementAvailable(string);
                break;
            }
            case 1: {
                long l = -1L;
                if (this.argument.length == 2) {
                    l = ((NumericValue)this.argument[1].evaluateItem(null)).longValue();
                }
                try {
                    String[] stringArray = Name.getQNameParts(string);
                    String string2 = stringArray[0];
                    String string3 = string2.equals("") ? staticContext.getDefaultFunctionNamespace() : staticContext.getURIForPrefix(string2);
                    int n = staticContext.getNamePool().allocate(string2, string3, stringArray[1]) & 0xFFFFF;
                    bl = staticContext.getFunctionLibrary().isAvailable(n, string3, stringArray[1], (int)l);
                    break;
                }
                catch (QNameException qNameException) {
                    throw new StaticError(qNameException.getMessage());
                }
            }
        }
        return BooleanValue.get(bl);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        long l = -1L;
        if (this.argument.length == 2) {
            l = ((NumericValue)this.argument[1].evaluateItem(xPathContext)).longValue();
        }
        StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
        String string2 = stringValue.getStringValue();
        String[] stringArray = null;
        try {
            stringArray = Name.getQNameParts(string2);
        }
        catch (QNameException qNameException) {
            string = this.operation == 1 ? "XT1400" : "XT1440";
            this.dynamicError(qNameException.getMessage(), string, xPathContext);
        }
        String string3 = stringArray[0];
        string = stringArray[1];
        String string4 = string3.equals("") ? (this.operation == 0 ? this.nsContext.getURIForPrefix(string3, true) : "http://www.w3.org/2004/07/xpath-functions") : this.nsContext.getURIForPrefix(string3, false);
        if (string4 == null) {
            this.dynamicError("Namespace prefix '" + string3 + "' has not been declared", xPathContext);
        }
        boolean bl = false;
        switch (this.operation) {
            case 0: {
                bl = this.isElementAvailable(string4, string, xPathContext);
                break;
            }
            case 1: {
                int n = xPathContext.getController().getNamePool().allocate(string3, string4, string) & 0xFFFFF;
                FunctionLibrary functionLibrary = xPathContext.getController().getExecutable().getFunctionLibrary();
                bl = functionLibrary.isAvailable(n, string4, string, (int)l);
            }
        }
        return BooleanValue.get(bl);
    }

    private boolean isElementAvailable(String string, String string2, XPathContext xPathContext) {
        try {
            if (this.styleNodeFactory == null) {
                NamePool namePool = new NamePool();
                this.styleNodeFactory = new StyleNodeFactory(namePool, xPathContext.getController().getConfiguration().isAllowExternalFunctions());
            }
            return this.styleNodeFactory.isElementAvailable(string, string2);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

